/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class ZombieVillager
extends EasyNPCBaseModelEntity<ZombieVillager> {
    public static final String ID = "zombie_villager";

    public ZombieVillager(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level, Variant.DEFAULT);
        this.getEntityAttributes().setEnvironmentalAttributes(this.getEntityAttributes().getEnvironmentalAttributes().withCanBreathUnderwater(true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.ZOMBIE_VILLAGER;
    }

    @Override
    public Component getName() {
        Component component = this.getCustomName();
        if (component != null) {
            return TextUtils.removeAction(component);
        }
        Component professionName = this.getProfessionName();
        Component variantName = this.getVariantName();
        return TextComponent.getText(variantName.getString() + " (" + professionName.getString() + ")");
    }

    @Override
    public boolean hasProfessions() {
        return true;
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.DEFAULT;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.ZOMBIE_VILLAGER_AMBIENT);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.ZOMBIE_VILLAGER_HURT);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.ZOMBIE_VILLAGER_DEATH);
        soundDataSet.addSound(SoundType.STEP, SoundEvents.ZOMBIE_VILLAGER_STEP);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    public static enum Variant {
        DEFAULT,
        DESERT,
        JUNGLE,
        PLAINS,
        SAVANNA,
        SNOW,
        SWAMP,
        TAIGA;

    }
}

