/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.menu.MenuHandlerInterface;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import de.markusbordihn.easynpc.menu.editor.EditorMenu;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

public class MenuHandler
implements MenuHandlerInterface {
    protected static final Map<ConfigurationType, MenuType<? extends ConfigurationMenu>> configurationMenuMap = new EnumMap<ConfigurationType, MenuType<? extends ConfigurationMenu>>(ConfigurationType.class);
    protected static final Map<EditorType, MenuType<? extends EditorMenu>> editorMenuMap = new EnumMap<EditorType, MenuType<? extends EditorMenu>>(EditorType.class);

    public static void registerMenuHandler(FMLCommonSetupEvent event) {
        configurationMenuMap.put(ConfigurationType.ABILITIES_ATTRIBUTE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.ABILITIES_ATTRIBUTE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.ADVANCED_DIALOG, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.ADVANCED_DIALOG_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.ADVANCED_POSE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.ADVANCED_POSE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.ADVANCED_TRADING, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.ADVANCED_TRADING_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.ATTACK_OBJECTIVE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.ATTACK_OBJECTIVE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.BASE_ATTRIBUTE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.BASE_ATTRIBUTE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.BASIC_ACTION, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.BASIC_ACTION_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.BASIC_DIALOG, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.BASIC_DIALOG_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.BASIC_OBJECTIVE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.BASIC_OBJECTIVE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.BASIC_TRADING, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.BASIC_TRADING_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.CUSTOM_POSE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.CUSTOM_POSE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.CUSTOM_PRESET_EXPORT, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.CUSTOM_EXPORT_PRESET_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.CUSTOM_PRESET_IMPORT, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.CUSTOM_IMPORT_PRESET_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.CUSTOM_MODEL, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.CUSTOM_MODEL_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.CUSTOM_SKIN, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.CUSTOM_SKIN_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.CUSTOM_TRADING, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.CUSTOM_TRADING_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DEFAULT_MODEL, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DEFAULT_MODEL_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DEFAULT_POSE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DEFAULT_POSE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DEFAULT_POSITION, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DEFAULT_POSITION_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DEFAULT_PRESET_IMPORT, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DEFAULT_IMPORT_PRESET_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DEFAULT_ROTATION, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DEFAULT_ROTATION_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DEFAULT_SKIN, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DEFAULT_SKIN_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DIALOG_ACTION, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DIALOG_ACTION_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DISPLAY_ATTRIBUTE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DISPLAY_ATTRIBUTE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.DISTANCE_ACTION, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.DISTANCE_ACTION_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.EQUIPMENT, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.EQUIPMENT_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.FOLLOW_OBJECTIVE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.FOLLOW_OBJECTIVE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.LOCAL_PRESET_IMPORT, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.LOCAL_IMPORT_PRESET_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.LOOK_OBJECTIVE, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.LOOK_OBJECTIVE_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.MAIN, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.MAIN_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.NONE_DIALOG, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.NONE_DIALOG_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.NONE_SKIN, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.NONE_SKIN_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.NONE_TRADING, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.NONE_TRADING_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.PLAYER_SKIN, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.PLAYER_SKIN_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.SCALING, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.SCALING_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.URL_SKIN, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.URL_SKIN_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.WORLD_PRESET_EXPORT, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.WORLD_EXPORT_PRESET_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.WORLD_PRESET_IMPORT, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.WORLD_IMPORT_PRESET_CONFIGURATION_MENU.get()));
        configurationMenuMap.put(ConfigurationType.YES_NO_DIALOG, (MenuType<? extends ConfigurationMenu>)((MenuType)ModMenuTypes.YES_NO_DIALOG_CONFIGURATION_MENU.get()));
        editorMenuMap.put(EditorType.ACTION_DATA, (MenuType<? extends EditorMenu>)((MenuType)ModMenuTypes.ACTION_DATA_EDITOR_MENU.get()));
        editorMenuMap.put(EditorType.ACTION_DATA_ENTRY, (MenuType<? extends EditorMenu>)((MenuType)ModMenuTypes.ACTION_DATA_ENTRY_EDITOR_MENU.get()));
        editorMenuMap.put(EditorType.DIALOG, (MenuType<? extends EditorMenu>)((MenuType)ModMenuTypes.DIALOG_EDITOR_MENU.get()));
        editorMenuMap.put(EditorType.DIALOG_BUTTON, (MenuType<? extends EditorMenu>)((MenuType)ModMenuTypes.DIALOG_BUTTON_EDITOR_MENU.get()));
        editorMenuMap.put(EditorType.DIALOG_TEXT, (MenuType<? extends EditorMenu>)((MenuType)ModMenuTypes.DIALOG_TEXT_EDITOR_MENU.get()));
    }

    private static boolean hasPermissions(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, Boolean enabled, Boolean allowInCreative, int permissionLevel) {
        OwnerData<?> ownerData = easyNPC.getEasyNPCOwnerData();
        if (Boolean.FALSE.equals(enabled) || serverPlayer == null) {
            return false;
        }
        if (Boolean.TRUE.equals(allowInCreative) && serverPlayer.isCreative()) {
            return true;
        }
        if (!ownerData.hasOwner() || !ownerData.isOwner(serverPlayer)) {
            return false;
        }
        return serverPlayer.hasPermissions(permissionLevel);
    }

    public static Map<ConfigurationType, MenuType<? extends ConfigurationMenu>> configurationMenuMap() {
        return configurationMenuMap;
    }

    public static Map<EditorType, MenuType<? extends EditorMenu>> editorMenuMap() {
        return editorMenuMap;
    }

    @Override
    public MenuType<? extends DialogMenu> getDialogMenuType() {
        return (MenuType)ModMenuTypes.DIALOG_MENU.get();
    }

    @Override
    public MenuType<? extends ConfigurationMenu> getMenuTypeByConfigurationType(ConfigurationType configurationType) {
        return configurationMenuMap.get((Object)configurationType);
    }

    @Override
    public MenuType<? extends EditorMenu> getMenuTypeByEditorType(EditorType editorType) {
        return editorMenuMap.get((Object)editorType);
    }
}

