/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.block.entity.BaseEasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.data.spawner.SpawnerSettingType;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public record ChangeSpawnerSettingMessage(BlockPos blockPos, SpawnerSettingType settingType, int settingValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"change_spawner_settings");
    public static final CustomPacketPayload.Type<ChangeSpawnerSettingMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeSpawnerSettingMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeSpawnerSettingMessage::create);

    public static ChangeSpawnerSettingMessage create(FriendlyByteBuf buffer) {
        return new ChangeSpawnerSettingMessage(buffer.readBlockPos(), (SpawnerSettingType)buffer.readEnum(SpawnerSettingType.class), buffer.readInt());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.blockPos);
        buffer.writeEnum((Enum)this.settingType);
        buffer.writeInt(this.settingValue);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            return;
        }
        ServerLevel serverLevel = serverPlayer.serverLevel();
        BlockEntity blockEntity = serverLevel.getBlockEntity(this.blockPos);
        if (blockEntity == null) {
            blockEntity = serverLevel.getChunkAt(this.blockPos).getBlockEntity(this.blockPos, LevelChunk.EntityCreationType.IMMEDIATE);
        }
        if (!(blockEntity instanceof BaseEasyNPCSpawnerBlockEntity)) {
            log.error("Found {}({}) instead of NPC spawner block entity at {}", (Object)blockEntity, (Object)serverLevel.getBlockState(this.blockPos), (Object)this.blockPos);
            return;
        }
        BaseEasyNPCSpawnerBlockEntity spawnerBlockEntity = (BaseEasyNPCSpawnerBlockEntity)blockEntity;
        if (!serverPlayer.isCreative() && spawnerBlockEntity.getOwner() != null && !spawnerBlockEntity.getOwner().equals(serverPlayer.getUUID())) {
            log.warn("Player {} has no permission to change the settings of spawner at {}", (Object)serverPlayer.getName().getString(), (Object)this.blockPos);
            return;
        }
        switch (this.settingType) {
            case SPAWN_RANGE: {
                log.debug("Set spawner {} spawn range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setSpawnRange(this.settingValue);
                break;
            }
            case DESPAWN_RANGE: {
                log.debug("Set spawner {} despawn range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setDespawnRange(this.settingValue);
                break;
            }
            case REQUIRED_PLAYER_RANGE: {
                log.debug("Set spawner {} required player range to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setRequiredPlayerRange(this.settingValue);
                break;
            }
            case DELAY: {
                log.debug("Set spawner {} delay to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setDelay(this.settingValue);
                break;
            }
            case MAX_NEARBY_ENTITIES: {
                log.debug("Set spawner {} max nearby entities to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setMaxNearbyEntities(this.settingValue);
                break;
            }
            case SPAWN_COUNT: {
                log.debug("Set spawner {} spawn count to {}", (Object)spawnerBlockEntity, (Object)this.settingValue);
                spawnerBlockEntity.setSpawnCount(this.settingValue);
                break;
            }
            default: {
                log.error("Unknown spawner setting type {} for {}", (Object)this.settingType, (Object)spawnerBlockEntity);
            }
        }
    }
}

