/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenConfigurationMessage(UUID uuid, ConfigurationType configurationType, int pageIndex) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"open_configuration_screen");
    public static final CustomPacketPayload.Type<OpenConfigurationMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenConfigurationMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenConfigurationMessage::create);

    public static OpenConfigurationMessage create(FriendlyByteBuf buffer) {
        return new OpenConfigurationMessage(buffer.readUUID(), (ConfigurationType)buffer.readEnum(ConfigurationType.class), buffer.readInt());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.configurationType);
        buffer.writeInt(this.pageIndex);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.configurationType == null) {
            log.error("Invalid configuration type for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.pageIndex < 0) {
            log.error("Invalid page index {} for {} from {}", (Object)this.pageIndex, easyNPC, (Object)serverPlayer);
            return;
        }
        MenuManager.getMenuHandler().openConfigurationMenu(this.configurationType, serverPlayer, easyNPC, this.pageIndex);
    }
}

