/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenDialogTextEditorMessage(UUID uuid, UUID dialogId) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"open_dialog_text_editor");
    public static final CustomPacketPayload.Type<OpenDialogTextEditorMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenDialogTextEditorMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenDialogTextEditorMessage::create);

    public static OpenDialogTextEditorMessage create(FriendlyByteBuf buffer) {
        return new OpenDialogTextEditorMessage(buffer.readUUID(), buffer.readUUID());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            log.debug("Available dialogs for {} are {}", easyNPC, (Object)dialogData.getDialogDataSet());
            return;
        }
        log.info("Open dialog editor with for dialog {} for {} from {}", (Object)this.dialogId, easyNPC, (Object)serverPlayer);
        MenuManager.getMenuHandler().openEditorMenu(EditorType.DIALOG_TEXT, serverPlayer, easyNPC, this.dialogId, 0);
    }
}

