/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModSoundEvents;

public class ThinIceBlock
extends IceBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public ThinIceBlock() {
        super(BlockBehaviour.Properties.of().friction(0.98f).strength(0.5f).sound(SoundType.GLASS).noOcclusion().isValidSpawn((state, blockGetter, pos, entityType) -> entityType.equals(EntityType.POLAR_BEAR) || entityType.equals(ModEntityTypes.PENGUIN)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        Player player;
        Holder.Reference ffholder = ((Registry)pLevel.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolderOrThrow(Enchantments.FEATHER_FALLING);
        if (pEntity instanceof Player && EnchantmentHelper.getEnchantmentLevel((Holder)ffholder, (LivingEntity)(player = (Player)pEntity)) == 0) {
            pLevel.playSound(null, pPos, ModSoundEvents.THIN_ICE_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.random.nextFloat() * 0.2f);
            this.replaceIfThinIce(pPos, 3, pLevel);
            this.replaceIfThinIce(pPos.north(), 2, pLevel);
            this.replaceIfThinIce(pPos.east(), 2, pLevel);
            this.replaceIfThinIce(pPos.south(), 2, pLevel);
            this.replaceIfThinIce(pPos.west(), 2, pLevel);
            this.replaceIfThinIce(pPos.north().west(), 1, pLevel);
            this.replaceIfThinIce(pPos.north().east(), 1, pLevel);
            this.replaceIfThinIce(pPos.south().west(), 1, pLevel);
            this.replaceIfThinIce(pPos.south().east(), 1, pLevel);
        }
    }

    private void replaceIfThinIce(BlockPos pPos, int age, Level pLevel) {
        BlockState state = pLevel.getBlockState(pPos);
        if (state.is(ModBlocks.THIN_ICE)) {
            pLevel.setBlock(pPos, (BlockState)ModBlocks.THIN_ICE.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min((Integer)state.getValue((Property)AGE) + age, 3))), 2);
        }
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pEntity instanceof Player && (Integer)pState.getValue((Property)AGE) > 0) {
            this.crack(pState, pLevel, pPos);
        }
    }

    private boolean crack(BlockState pState, Level pLevel, BlockPos pPos) {
        int age = (Integer)pState.getValue((Property)AGE);
        if (age < 3) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            pLevel.playSound(null, pPos, ModSoundEvents.THIN_ICE_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.random.nextFloat() * 0.2f);
            return false;
        }
        pLevel.removeBlock(pPos, false);
        if (!pLevel.dimensionType().ultraWarm() && (pState.blocksMotion() || pState.getFluidState().getType() != Fluids.EMPTY)) {
            pLevel.setBlockAndUpdate(pPos, Blocks.WATER.defaultBlockState());
        }
        pLevel.playSound(null, pPos, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{AGE});
    }
}

