/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModItems;

public class ModBoat
extends Boat {
    private static final EntityDataAccessor<Integer> WOOD_TYPE = SynchedEntityData.defineId(ModBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ModBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public ModBoat(Level level, double x, double y, double z) {
        this(ModEntityTypes.BOAT, level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WOOD_TYPE, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.contains("Type", 8)) {
            this.setWoodType(Type.byName(pCompound.getString("Type")));
        }
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putString("Type", this.getWoodType().getName());
    }

    public Type getWoodType() {
        return Type.byId((Integer)this.entityData.get(WOOD_TYPE));
    }

    public void setWoodType(Type type) {
        this.entityData.set(WOOD_TYPE, (Object)type.ordinal());
    }

    public Item getDropItem() {
        return this.getWoodType().getItem().get();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public static enum Type {
        COCONUT("coconut", () -> ModItems.COCONUT_BOAT, () -> ModItems.COCONUT_CHEST_BOAT),
        WALNUT("walnut", () -> ModItems.WALNUT_BOAT, () -> ModItems.WALNUT_CHEST_BOAT),
        AZALEA("azalea", () -> ModItems.AZALEA_BOAT, () -> ModItems.AZALEA_CHEST_BOAT),
        FLOWERING_AZALEA("flowering_azalea", () -> ModItems.FLOWERING_AZALEA_BOAT, () -> ModItems.FLOWERING_AZALEA_CHEST_BOAT);

        private final String name;
        private final Supplier<Item> item;
        private final Supplier<Item> chestItem;

        private Type(String name, Supplier<Item> boatItem, Supplier<Item> chestBoatItem) {
            this.name = name;
            this.item = boatItem;
            this.chestItem = chestBoatItem;
        }

        public ResourceLocation getTexture(boolean hasChest) {
            if (hasChest) {
                return ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)("textures/entity/chest_boat/" + this.name + ".png"));
            }
            return ResourceLocation.fromNamespaceAndPath((String)"ecologics", (String)("textures/entity/boat/" + this.name + ".png"));
        }

        public String getModelLocation() {
            return "boat/" + this.name;
        }

        public String getChestModelLocation() {
            return "chest_boat/" + this.name;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<Item> getItem() {
            return this.item;
        }

        public Supplier<Item> getChestItem() {
            return this.chestItem;
        }

        public static Type byId(int id) {
            Type[] values = Type.values();
            if (id < 0 || id >= values.length) {
                id = 0;
            }
            return values[id];
        }

        public static Type byName(String name) {
            Type[] values = Type.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getName().equals(name)) continue;
                return values[i];
            }
            return values[0];
        }
    }
}

