/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.level;

import com.vsngarcia.ElevatorBlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ElevatorBlockEntityBase
extends BlockEntity
implements MenuProvider {
    protected BlockState heldState;

    public ElevatorBlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider holder) {
        super.loadAdditional(tag, holder);
        if (tag.contains("held_id", 10)) {
            BlockState state = NbtUtils.readBlockState((HolderGetter)(this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup()), (CompoundTag)tag.getCompound("held_id"));
            this.heldState = this.isValidState(state) ? state : null;
        } else {
            this.heldState = null;
        }
        if (this.level != null && this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), null, null, 0);
            this.level.getLightEngine().checkBlock(this.getBlockPos());
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider holder) {
        super.saveAdditional(tag, holder);
        if (this.heldState != null) {
            tag.put("held_id", (Tag)NbtUtils.writeBlockState((BlockState)this.heldState));
        } else {
            tag.putBoolean("held_id", false);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider holder) {
        return this.saveCustomOnly(holder);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"screen.elevatorid.elevator");
    }

    public void setHeldState(BlockState state) {
        this.heldState = state;
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            this.level.getLightEngine().checkBlock(this.getBlockPos());
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
            this.getBlockState().updateNeighbourShapes((LevelAccessor)this.level, this.getBlockPos(), 0);
            if (this.heldState != null) {
                for (Direction direction : Direction.values()) {
                    this.getBlockState().updateShape(direction, this.level.getBlockState(this.getBlockPos().relative(direction)), (LevelAccessor)this.level, this.getBlockPos(), this.getBlockPos().relative(direction));
                }
            }
        }
    }

    public BlockState getHeldState() {
        return this.heldState;
    }

    public boolean setCamoAndUpdate(BlockState newState) {
        if (this.heldState == newState) {
            return false;
        }
        if (!this.isValidState(newState)) {
            return false;
        }
        this.setHeldState(newState);
        if (this.getLevel() != null) {
            this.getLevel().playSound(null, this.getBlockPos(), this.camouflageSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    protected abstract SoundEvent camouflageSound();

    public boolean isValidState(BlockState state) {
        if (state == null) {
            return true;
        }
        if (state.getBlock() == Blocks.AIR) {
            return false;
        }
        if (state.getBlock() instanceof ElevatorBlockBase) {
            return false;
        }
        if (state.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        return !state.getCollisionShape((BlockGetter)this.level, this.worldPosition).isEmpty();
    }
}

