/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.arch.network.client.ClientNetwork;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class PlatformTools {
    public static INetworkInstance getClientNetworkController() {
        return ClientNetwork.INSTANCE;
    }

    @Nullable
    public static IEmotePlayerEntity getPlayerFromUUID(UUID uuid) {
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        return (IEmotePlayerEntity)Minecraft.getInstance().level.getPlayerByUUID(uuid);
    }

    public static void openExternalEmotesDir() {
        Util.getPlatform().openFile(EmoteInstance.instance.getExternalEmoteDir());
    }

    public static Component fromJson(String json) {
        if (json == null) {
            return Component.literal((String)"");
        }
        try {
            return Component.Serializer.fromJson((JsonElement)JsonParser.parseString((String)json), (HolderLookup.Provider)RegistryAccess.EMPTY);
        }
        catch (JsonParseException e) {
            return Component.literal((String)json);
        }
    }

    public static Component fromJson(Object obj) {
        if (obj == null || obj instanceof String) {
            return PlatformTools.fromJson((String)obj);
        }
        if (obj instanceof JsonElement) {
            return Component.Serializer.fromJson((JsonElement)((JsonElement)obj), (HolderLookup.Provider)RegistryAccess.EMPTY);
        }
        throw new IllegalArgumentException("Can not create Text from " + obj.getClass().getName());
    }

    public static ResourceLocation newIdentifier(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"emotecraft", (String)id);
    }
}

