/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.eventslib.mixins;

import com.sts15.eventslib.effect.IMobEffectEndCallback;
import com.sts15.eventslib.events.MobEffectExpiredEvent;
import com.sts15.eventslib.events.MobEffectRemovedEvent;
import com.sts15.eventslib.util.EffectDurationTracker;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"onEffectRemoved"}, at={@At(value="HEAD")})
    public void onEffectRemoved(MobEffectInstance inst, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (self.level().isClientSide) {
            return;
        }
        if (inst.getDuration() <= 0) {
            NeoForge.EVENT_BUS.post((Event)new MobEffectExpiredEvent(self, inst));
        } else {
            NeoForge.EVENT_BUS.post((Event)new MobEffectRemovedEvent(self, inst));
        }
        Object object = inst.getEffect().value();
        if (object instanceof IMobEffectEndCallback) {
            IMobEffectEndCallback cb = (IMobEffectEndCallback)object;
            cb.onEffectRemoved(self, inst.getAmplifier());
        }
        EffectDurationTracker.getInstance().removeEffect(self.getUUID(), inst);
    }
}

