/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.eventslib.util;

import com.sts15.eventslib.events.MobEffectAppliedEvent;
import com.sts15.eventslib.events.MobEffectTickEvent;
import com.sts15.eventslib.util.EffectData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class EffectDurationTracker {
    private static final EffectDurationTracker INSTANCE = new EffectDurationTracker();
    private final Map<UUID, Map<MobEffect, TrackerEntry>> tracked = new HashMap<UUID, Map<MobEffect, TrackerEntry>>();

    private EffectDurationTracker() {
    }

    public static EffectDurationTracker getInstance() {
        return INSTANCE;
    }

    public void addOrUpdateEffect(UUID entityId, LivingEntity entity, MobEffectInstance inst) {
        MobEffect type;
        Map map = this.tracked.computeIfAbsent(entityId, k -> new HashMap());
        if (!map.containsKey(type = (MobEffect)inst.getEffect().value())) {
            TrackerEntry te = new TrackerEntry(inst);
            map.put(type, te);
            NeoForge.EVENT_BUS.post((Event)new MobEffectAppliedEvent(entity, inst));
        } else {
            TrackerEntry te = (TrackerEntry)map.get(type);
            te.instance = inst;
        }
    }

    public void tickAll(LivingEntity entity) {
        Map<MobEffect, TrackerEntry> map = this.tracked.get(entity.getUUID());
        if (map == null) {
            return;
        }
        for (TrackerEntry te : map.values()) {
            MobEffectInstance inst = te.instance;
            float pct = (float)inst.getDuration() / (float)te.data.getInitialDuration() * 100.0f;
            NeoForge.EVENT_BUS.post((Event)new MobEffectTickEvent(entity, inst, pct));
            inst.tick(entity, () -> {});
        }
    }

    public void removeEffect(UUID entityId, MobEffectInstance inst) {
        Map<MobEffect, TrackerEntry> map = this.tracked.get(entityId);
        if (map != null) {
            map.remove(inst.getEffect().value());
            if (map.isEmpty()) {
                this.tracked.remove(entityId);
            }
        }
    }

    public Map<UUID, Map<MobEffect, TrackerEntry>> getTrackedEffects() {
        return this.tracked;
    }

    private static class TrackerEntry {
        MobEffectInstance instance;
        EffectData data;

        TrackerEntry(MobEffectInstance inst) {
            this.instance = inst;
            this.data = new EffectData(inst.getDuration());
        }
    }
}

