/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tschipp.fakename.CommandFakeName;
import tschipp.fakename.Config;
import tschipp.fakename.FakeNamePacket;

@Mod(value="fakename")
public class FakeName {
    public static final String MODID = "fakename";
    public static final StreamCodec<RegistryFriendlyByteBuf, FakeNamePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, FakeNamePacket::fakename, (StreamCodec)ByteBufCodecs.INT, FakeNamePacket::entityId, (StreamCodec)ByteBufCodecs.INT, FakeNamePacket::deleteFakename, FakeNamePacket::new);
    public static final CustomPacketPayload.Type<FakeNamePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fakename", (String)"fakenamepacket"));
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"fakename");
    private static final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<CommandFakeName.FakenameArgumentType>> FAKENAME_ARGUMENT = COMMAND_ARGUMENT_TYPES.register("fakename", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(CommandFakeName.FakenameArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(CommandFakeName.FakenameArgumentType::fakename)));

    public FakeName(ModContainer container) {
        COMMAND_ARGUMENT_TYPES.register(container.getEventBus());
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        container.getEventBus().addListener(this::registerPackets);
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1.0.0");
        registrar.playToClient(TYPE, CODEC, FakeNamePacket::handle);
    }

    public static void sendPacket(Player player, String fakename, int operation) {
        FakeName.performFakenameOperation(player, fakename, operation);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new FakeNamePacket(fakename, player.getId(), operation), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void performFakenameOperation(Player player, String fakename, int operation) {
        CompoundTag tag = player.getPersistentData();
        if (operation == 0) {
            tag.putString(MODID, fakename);
            player.refreshDisplayName();
        } else {
            tag.remove(MODID);
            player.refreshDisplayName();
        }
    }
}

