/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.block.entity.pedestal;

import com.sts15.fargos.block.entity.BlockEntitiesInit;
import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Air_Talisman_Provider;
import com.sts15.fargos.items.providers.Amethyst_Talisman_Provider;
import com.sts15.fargos.items.providers.Architect_Talisman_Provider;
import com.sts15.fargos.items.providers.Arctic_Talisman_Provider;
import com.sts15.fargos.items.providers.Battle_Talisman_Provider;
import com.sts15.fargos.items.providers.Blaze_Talisman_Provider;
import com.sts15.fargos.items.providers.Blinded_Talisman_Provider;
import com.sts15.fargos.items.providers.Cactus_Talisman_Provider;
import com.sts15.fargos.items.providers.Creeper_Talisman_Provider;
import com.sts15.fargos.items.providers.Day_Talisman_Provider;
import com.sts15.fargos.items.providers.Diamond_Talisman_Provider;
import com.sts15.fargos.items.providers.Dragon_Talisman_Provider;
import com.sts15.fargos.items.providers.Earth_Talisman_Provider;
import com.sts15.fargos.items.providers.Emerald_Talisman_Provider;
import com.sts15.fargos.items.providers.Enchanting_Talisman_Provider;
import com.sts15.fargos.items.providers.Enderman_Talisman_Provider;
import com.sts15.fargos.items.providers.Fatigued_Talisman_Provider;
import com.sts15.fargos.items.providers.Fire_Talisman_Provider;
import com.sts15.fargos.items.providers.Fired_Talisman_Provider;
import com.sts15.fargos.items.providers.Full_Moon_Talisman_Provider;
import com.sts15.fargos.items.providers.Ghast_Talisman_Provider;
import com.sts15.fargos.items.providers.Glowstone_Talisman_Provider;
import com.sts15.fargos.items.providers.Gold_Talisman_Provider;
import com.sts15.fargos.items.providers.Iron_Golem_Talisman_Provider;
import com.sts15.fargos.items.providers.Lapis_Talisman_Provider;
import com.sts15.fargos.items.providers.Librarian_Talisman_Provider;
import com.sts15.fargos.items.providers.Nauseated_Talisman_Provider;
import com.sts15.fargos.items.providers.Night_Talisman_Provider;
import com.sts15.fargos.items.providers.Poisoned_Talisman_Provider;
import com.sts15.fargos.items.providers.Rain_Talisman_Provider;
import com.sts15.fargos.items.providers.Redstone_Talisman_Provider;
import com.sts15.fargos.items.providers.Shulker_Talisman_Provider;
import com.sts15.fargos.items.providers.Skeleton_Talisman_Provider;
import com.sts15.fargos.items.providers.Slowed_Talisman_Provider;
import com.sts15.fargos.items.providers.Snowy_Talisman_Provider;
import com.sts15.fargos.items.providers.Soul_of_Colossus_Provider;
import com.sts15.fargos.items.providers.Soul_of_Flight_Mastery_Provider;
import com.sts15.fargos.items.providers.Soul_of_Supersonic_Provider;
import com.sts15.fargos.items.providers.Spectral_Talisman_Provider;
import com.sts15.fargos.items.providers.Storm_Talisman_Provider;
import com.sts15.fargos.items.providers.Sun_Talisman_Provider;
import com.sts15.fargos.items.providers.Thorny_Talisman_Provider;
import com.sts15.fargos.items.providers.True_Sun_Talisman_Provider;
import com.sts15.fargos.items.providers.Undying_Talisman_Provider;
import com.sts15.fargos.items.providers.Vampiric_Talisman_Provider;
import com.sts15.fargos.items.providers.Vindicator_Talisman_Provider;
import com.sts15.fargos.items.providers.Void_Talisman_Provider;
import com.sts15.fargos.items.providers.Water_Talisman_Provider;
import com.sts15.fargos.items.providers.Weakened_Talisman_Provider;
import com.sts15.fargos.items.providers.Witch_Talisman_Provider;
import com.sts15.fargos.items.providers.Wither_Talisman_Provider;
import com.sts15.fargos.items.providers.Withered_Talisman_Provider;
import com.sts15.fargos.items.providers.Zombie_Talisman_Provider;
import com.sts15.fargos.items.talismans.Apple_Talisman;
import com.sts15.fargos.items.talismans.Copper_Talisman;
import com.sts15.fargos.items.talismans.Iron_Talisman;
import com.sts15.fargos.items.talismans.Mooshroom_Talisman;
import com.sts15.fargos.items.talismans.Nether_Star_Talisman;
import com.sts15.fargos.items.talismans.Obsidian_Talisman;
import com.sts15.fargos.items.talismans.Pickaxe_Talisman;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class PedestalBlockEntity
extends BlockEntity
implements Container {
    public final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            PedestalBlockEntity.this.setChanged();
            if (!PedestalBlockEntity.this.level.isClientSide()) {
                PedestalBlockEntity.this.level.sendBlockUpdated(PedestalBlockEntity.this.getBlockPos(), PedestalBlockEntity.this.getBlockState(), PedestalBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private float rotation;
    private int tickCounter = 0;

    public PedestalBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesInit.PEDESTAL_BE.get(), pPos, pBlockState);
    }

    public double getPedestalTier() {
        double range = 5.0;
        BlockPos blockBelow = this.worldPosition.below();
        BlockState blockStateBelow = this.level.getBlockState(blockBelow);
        if (blockStateBelow.is(Blocks.AMETHYST_BLOCK)) {
            range = 9.0;
        } else if (blockStateBelow.is(Blocks.BEACON)) {
            range = 15.0;
        } else if (blockStateBelow.is(Blocks.CHORUS_FLOWER)) {
            range = 20.0;
        }
        return range;
    }

    public List<Player> getPlayersInRange() {
        double range = this.getPedestalTier();
        AABB aabb = new AABB(this.worldPosition).inflate(range);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getEntitiesOfClass(Player.class, aabb);
        }
        return List.of();
    }

    public void applyItemSpecificEffect() {
        ItemStack itemStack = this.getItem(0);
        if (itemStack.isEmpty()) {
            return;
        }
        if (itemStack.getItem() instanceof Emerald_Talisman_Provider) {
            this.applyEmeraldTalismanEffect();
        }
    }

    public void applyTalismanEffect() {
        ItemStack itemStack = this.getItem(0);
        if (itemStack.isEmpty()) {
            return;
        }
        List<Player> players = this.getPlayersInRange();
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (itemStack.getItem() instanceof Air_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.AIR_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Amethyst_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.AMETHYST_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Apple_Talisman) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.APPLE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Architect_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.ARCHITECT_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Arctic_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.ARCTIC_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Battle_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.BATTLE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Blaze_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.BLAZE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Blinded_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.BLINDED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Cactus_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.CACTUS_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Copper_Talisman) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.COPPER_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Creeper_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.CREEPER_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Day_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.DAY_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Diamond_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.DIAMOND_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Dragon_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.DRAGON_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Earth_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.EARTH_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Emerald_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.EMERALD_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Enchanting_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.ENCHANTING_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Enderman_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.ENDERMAN_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Fatigued_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.FATIGUED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Fire_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.FIRE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Fired_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.FIRED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Full_Moon_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.FULL_MOON_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Ghast_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.GHAST_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Glowstone_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.GLOWSTONE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Gold_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.GOLD_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Iron_Golem_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.IRON_GOLEM_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Iron_Talisman) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.IRON_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Lapis_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.LAPIS_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Librarian_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.LIBRARIAN_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Mooshroom_Talisman) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.MOOSHROOM_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Nauseated_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.NAUSEATED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Nether_Star_Talisman) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.NETHER_STAR_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Night_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.NIGHT_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Obsidian_Talisman) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.OBSIDIAN_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Pickaxe_Talisman) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.PICKAXE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Poisoned_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.POISONED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Rain_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.RAIN_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Redstone_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.REDSTONE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Shulker_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SHULKER_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Skeleton_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SKELETON_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Slowed_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SLOWED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Snowy_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SNOWY_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Spectral_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SPECTRAL_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Storm_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.STORM_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Sun_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SUN_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Thorny_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.THORNY_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof True_Sun_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.TRUE_SUN_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Undying_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.UNDYING_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Vampiric_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.VAMPIRIC_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Vindicator_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.VINDICATOR_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Void_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.VOID_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Water_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.WATER_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Weakened_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.WEAKENED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Witch_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.WITCH_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Wither_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.WITHER_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Withered_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.WITHERED_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Zombie_Talisman_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.ZOMBIE_TALISMAN_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Soul_of_Colossus_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SOUL_OF_COLOSSUS_EFFECT, 219, 0, false, false));
            }
            if (itemStack.getItem() instanceof Soul_of_Flight_Mastery_Provider) {
                serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SOUL_OF_FLIGHT_MASTERY_EFFECT, 219, 0, false, false));
            }
            if (!(itemStack.getItem() instanceof Soul_of_Supersonic_Provider)) continue;
            serverPlayer.addEffect(new MobEffectInstance(EffectsInit.SOUL_OF_SUPERSONIC_EFFECT, 219, 0, false, false));
        }
    }

    public static void tickEntity(Level level, BlockPos pos, BlockState state, PedestalBlockEntity blockEntity) {
        if (!level.isClientSide) {
            blockEntity.applyItemSpecificEffect();
            ++blockEntity.tickCounter;
            if (blockEntity.tickCounter >= 10) {
                blockEntity.applyTalismanEffect();
                blockEntity.tickCounter = 0;
            }
        }
    }

    private void applyEmeraldTalismanEffect() {
        if (!this.level.isClientSide()) {
            AABB aabb = new AABB(this.worldPosition).inflate(this.getPedestalTier());
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos.betweenClosedStream((AABB)aabb).forEach(blockPos -> {
                    BlockState blockState = this.level.getBlockState(blockPos);
                    if (CommonHooks.canCropGrow((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState, (boolean)true)) {
                        blockState.randomTick(serverLevel, blockPos, this.level.random);
                    }
                    if (blockState.is(Blocks.CHORUS_FLOWER) && (Integer)blockState.getValue((Property)ChorusFlowerBlock.AGE) < 5) {
                        blockState.randomTick(serverLevel, blockPos, this.level.random);
                    }
                });
            }
        }
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int pSlot) {
        this.setChanged();
        return this.itemHandler.getStackInSlot(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        this.setChanged();
        ItemStack stack = this.itemHandler.getStackInSlot(pSlot);
        stack.shrink(pAmount);
        return this.itemHandler.insertItem(pSlot, stack, false);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        this.setChanged();
        return pSlot >= 0 && pSlot < this.getContainerSize() ? this.itemHandler.insertItem(pSlot, ItemStack.EMPTY, false) : ItemStack.EMPTY;
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.setChanged();
        this.itemHandler.insertItem(pSlot, pStack.copyWithCount(1), false);
    }

    public boolean stillValid(Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.itemHandler.extractItem(i, 64, false);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
    }

    public float getRenderingRotation() {
        this.rotation += 0.5f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

