/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;

public class FireUIRenderer {
    public static final ResourceLocation FIRE_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"textures/gui/hud/fire.png");
    public static final ResourceLocation FIRE_EMPTY_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"textures/gui/hud/fire_extinguish.png");

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiLayerEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || !FireUIRenderer.shouldShowFireUI((Player)player)) {
            return;
        }
        GuiGraphics gui = event.getGuiGraphics();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int xStart = screenWidth / 2 + 91;
        int fireTime = FireUIRenderer.getFireShieldTime((Player)player);
        if (fireTime <= 0) {
            return;
        }
        int maxFireTime = 200;
        int fullIcons = Mth.ceil((double)((double)(fireTime - 2) * 10.0 / (double)maxFireTime));
        int partialIcons = Mth.ceil((double)((double)fireTime * 10.0 / (double)maxFireTime)) - fullIcons;
        int totalIcons = fullIcons + partialIcons;
        int y = screenHeight - 49;
        int iconSize = 9;
        RenderSystem.enableBlend();
        for (int i = 0; i < totalIcons; ++i) {
            int x = xStart - i * 8 - 9;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(i < fullIcons ? FIRE_SPRITE : FIRE_EMPTY_SPRITE));
            gui.blit(i < fullIcons ? FIRE_SPRITE : FIRE_EMPTY_SPRITE, x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        RenderSystem.disableBlend();
    }

    private static int getFireShieldTime(Player player) {
        return player.getPersistentData().getInt("FireShieldDuration");
    }

    private static boolean shouldShowFireUI(Player player) {
        return FireUIRenderer.getFireShieldTime(player) > 0;
    }
}

