/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.effect.talismans;

import com.sts15.eventslib.effect.MobEffectEndEffect;
import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Soul_of_Colossus_Provider;
import com.sts15.fargos.items.souls.Soul_of_Colossus;
import com.sts15.fargos.utils.TalismanUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class SoulOfColossusEffect
extends MobEffectEndEffect {
    public SoulOfColossusEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
        if (entity instanceof ServerPlayer && TalismanUtil.isTalismanEnabled((ServerPlayer)entity, "soul_of_colossus")) {
            Soul_of_Colossus.increaseHealth((Player)entity);
        }
    }

    public void onEffectRemoved(LivingEntity entity, int amplifier) {
        super.onEffectRemoved(entity, amplifier);
        if (entity instanceof Player) {
            Soul_of_Colossus.resetHealth((Player)entity);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                if (player2.tickCount % 10 == 0) {
                    boolean hasSoulOfColossusEffect = player2.hasEffect(EffectsInit.SOUL_OF_COLOSSUS_EFFECT);
                    boolean hasEquippedCurio = CuriosApi.getCuriosHelper().findEquippedCurio(equippedStack -> equippedStack.getItem() instanceof Soul_of_Colossus_Provider, (LivingEntity)player2).isPresent();
                    if (hasSoulOfColossusEffect) {
                        if (TalismanUtil.isTalismanEnabled(player2, "soul_of_colossus")) {
                            Soul_of_Colossus.increaseHealth((Player)player2);
                        } else if (!hasEquippedCurio) {
                            Soul_of_Colossus.resetHealth((Player)player2);
                        }
                    }
                }
            }
        }
    }
}

