/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.events;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.ItemInit;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="fargostalismans")
public class LootDropHandler {
    private static final List<Supplier<? extends Item>> CUSTOM_ITEMS = Arrays.asList(ItemInit.FLYING_CARPET, ItemInit.SWEETHEART_NECKLACE, ItemInit.AMBER_HORSESHOE_BALLOON, ItemInit.BUNDLE_OF_HORSESHOE_BALLOONS, ItemInit.SHIELD_OF_CTHULHU, ItemInit.MASTER_NINJA_GEAR, ItemInit.BLESSED_APPLE, ItemInit.MECHANICAL_CART, ItemInit.ANCIENT_HORN, ItemInit.REINDEER_BELLS, ItemInit.BRAIN_SCRAMBLER, ItemInit.AEOLUS_BOOTS);
    private static ResourceLocation cachedStructureLocation = null;
    private static final Random RANDOM = new Random();
    public static final Logger LOG = LoggerFactory.getLogger((String)"fargostalismans");

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Level world = event.getEntity().level();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            EntityType entityType = event.getEntity().getType();
            if (LootDropHandler.isTargetMob(event.getEntity().getType())) {
                ItemStack loot;
                BlockPos entityPos = event.getEntity().blockPosition();
                ResourceLocation customStructureLocation = LootDropHandler.getStructureLocation();
                Registry structureRegistry = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE);
                Structure customStructure = (Structure)structureRegistry.get(customStructureLocation);
                if (customStructure != null && serverLevel.structureManager().getStructureAt(entityPos, customStructure).isValid() && LootDropHandler.shouldDropLoot(player) && !(loot = LootDropHandler.getRandomCustomItem()).isEmpty()) {
                    event.getEntity().spawnAtLocation(loot);
                }
            }
            if (entityType == EntityType.WITHER) {
                LootDropHandler.spawnCustomDrop(event.getEntity().blockPosition(), serverLevel, (Item)ItemInit.ABOMINABLE_ENERGY.get(), 1, 2, player);
            } else if (entityType == EntityType.WARDEN) {
                LootDropHandler.spawnCustomDrop(event.getEntity().blockPosition(), serverLevel, (Item)ItemInit.ABOMINABLE_ENERGY.get(), 2, 3, player);
            } else if (entityType == EntityType.ENDER_DRAGON) {
                LootDropHandler.spawnCustomDrop(event.getEntity().blockPosition(), serverLevel, (Item)ItemInit.ABOMINABLE_ENERGY.get(), 3, 4, player);
            }
        }
    }

    private static void spawnCustomDrop(BlockPos pos, ServerLevel serverLevel, Item item, int min, int max, Player player) {
        int baseDrop = RANDOM.nextInt(max - min + 1) + min;
        Registry enchantmentRegistry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference lootingEnchantment = enchantmentRegistry.getHolderOrThrow(Enchantments.LOOTING);
        int lootingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lootingEnchantment, (ItemStack)player.getMainHandItem());
        int maxBonus = 6;
        double diminishingFactor = 0.5;
        int bonusDrop = (int)Math.min((double)maxBonus, Math.ceil((double)lootingLevel * diminishingFactor));
        int totalDrop = baseDrop + RANDOM.nextInt(bonusDrop + 1);
        for (int i = 0; i < totalDrop; ++i) {
            serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)item)));
        }
    }

    private static boolean isTargetMob(EntityType<?> entityType) {
        return entityType == EntityType.PIGLIN || entityType == EntityType.PIGLIN_BRUTE || entityType == EntityType.MAGMA_CUBE || entityType == EntityType.WITHER_SKELETON || entityType == EntityType.SKELETON || entityType == EntityType.BOGGED || entityType == EntityType.ZOMBIFIED_PIGLIN;
    }

    private static boolean shouldDropLoot(Player player) {
        Registry enchantmentRegistry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference lootingEnchantment = enchantmentRegistry.getHolderOrThrow(Enchantments.LOOTING);
        int lootingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lootingEnchantment, (ItemStack)player.getMainHandItem());
        double chance = 0.05 + (double)lootingLevel * 0.02;
        return RANDOM.nextDouble() < chance;
    }

    private static ItemStack getRandomCustomItem() {
        Supplier<? extends Item> randomItemSupplier = CUSTOM_ITEMS.get(RANDOM.nextInt(CUSTOM_ITEMS.size()));
        return new ItemStack((ItemLike)randomItemSupplier.get());
    }

    private static ResourceLocation getStructureLocation() {
        if (cachedStructureLocation == null) {
            if (((Boolean)Config.USE_CUSTOM_STRUCTURE.get()).booleanValue()) {
                String id = (String)Config.CUSTOM_STRUCTURE_ID.get();
                cachedStructureLocation = ResourceLocation.tryParse((String)id);
                if (cachedStructureLocation == null) {
                    LOG.info("Failed to parse custom structure ID from config: '{}'. Falling back to default.", (Object)id);
                    cachedStructureLocation = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"dungeon2");
                } else {
                    LOG.info("Using custom structure for loot detection: {}", (Object)cachedStructureLocation);
                }
            } else {
                cachedStructureLocation = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"dungeon2");
                LOG.info("Using default structure for loot detection: {}", (Object)cachedStructureLocation);
            }
        }
        return cachedStructureLocation;
    }
}

