/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.looted;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Charm_of_Myths_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class CharmOfMythsItem
extends TalismanItem
implements Charm_of_Myths_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    private static final String charmName = "charm_of_myths";
    private static final int REGEN_AMPLIFIER = 0;
    private static final int REGEN_DURATION = 40;

    public CharmOfMythsItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.charm_of_myths").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!CharmOfMythsItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for charm_of_myths", (Throwable)e);
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean hasCharmEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Charm_of_Myths_Provider, (LivingEntity)player2).isPresent();
            if (!hasCharmEquipped || !CharmOfMythsItem.checkConfigEnabledStatus()) {
                Events.removeCharmRegen((Player)player2);
                return;
            }
            if (!TalismanUtil.isTalismanEnabled(player2, CharmOfMythsItem.charmName)) {
                return;
            }
            float currentHealth = player2.getHealth();
            float maxHealth = player2.getMaxHealth();
            FoodData foodData = player2.getFoodData();
            int foodLevel = foodData.getFoodLevel();
            if (currentHealth < maxHealth && foodLevel >= 18) {
                Events.applyCharmRegen((Player)player2);
            }
        }

        private static void applyCharmRegen(Player player) {
            MobEffectInstance newRegen = new MobEffectInstance(MobEffects.REGENERATION, 40, 0, false, false);
            MobEffectInstance current = player.getEffect(MobEffects.REGENERATION);
            if (current == null || current.getAmplifier() < 0 || current.getDuration() < 10) {
                player.addEffect(newRegen);
            }
        }

        private static void removeCharmRegen(Player player) {
            MobEffectInstance current = player.getEffect(MobEffects.REGENERATION);
            if (current != null) {
                boolean isOurEffect;
                boolean bl = isOurEffect = current.getAmplifier() == 0 && current.getDuration() <= 40;
                if (isOurEffect) {
                    player.removeEffect(MobEffects.REGENERATION);
                }
            }
        }
    }
}

