/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.looted;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Hero_Shield_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class HeroShieldItem
extends TalismanItem
implements Hero_Shield_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    private static final String charmName = "hero_shield";
    private static final ResourceLocation HERO_SHIELD_KNOCKBACK_RES_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"hero_shield_aggro");
    private static final AttributeModifier HERO_SHIELD_KB_RESIST_MODIFIER = new AttributeModifier(HERO_SHIELD_KNOCKBACK_RES_ID, 1.0, AttributeModifier.Operation.ADD_VALUE);

    public HeroShieldItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.hero_shield").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!HeroShieldItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (Exception e) {
            LOGGER.error("Error checking config status for hero_shield", (Throwable)e);
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean hasShieldEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Hero_Shield_Provider, (LivingEntity)player2).isPresent();
            if (!TalismanUtil.isTalismanEnabled(player2, HeroShieldItem.charmName)) {
                return;
            }
            if (hasShieldEquipped && HeroShieldItem.checkConfigEnabledStatus()) {
                Events.addKnockbackResistance((Player)player2);
            } else {
                Events.removeKnockbackResistance((Player)player2);
            }
        }

        private static void addKnockbackResistance(Player player) {
            AttributeInstance kbAttr = player.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            if (kbAttr != null && !kbAttr.hasModifier(HERO_SHIELD_KB_RESIST_MODIFIER.id())) {
                kbAttr.addTransientModifier(HERO_SHIELD_KB_RESIST_MODIFIER);
            }
        }

        private static void removeKnockbackResistance(Player player) {
            AttributeInstance kbAttr = player.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            if (kbAttr != null && kbAttr.hasModifier(HERO_SHIELD_KB_RESIST_MODIFIER.id())) {
                kbAttr.removeModifier(HERO_SHIELD_KB_RESIST_MODIFIER);
            }
        }

        @SubscribeEvent
        public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
            ServerLevel serverLevel;
            List shieldBearers;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)livingEntity;
            if (!HeroShieldItem.checkConfigEnabledStatus()) {
                return;
            }
            double radius = 16.0;
            Level level = mob.level();
            if (level instanceof ServerLevel && !(shieldBearers = (serverLevel = (ServerLevel)level).getEntitiesOfClass(ServerPlayer.class, new AABB(mob.blockPosition()).inflate(radius), player -> CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Hero_Shield_Provider, (LivingEntity)player).isPresent() && TalismanUtil.isTalismanEnabled(player, HeroShieldItem.charmName))).isEmpty()) {
                shieldBearers.stream().filter(arg_0 -> ((Mob)mob).hasLineOfSight(arg_0)).min(Comparator.comparingDouble(p -> p.distanceToSqr((Entity)mob))).ifPresent(arg_0 -> ((LivingChangeTargetEvent)event).setNewAboutToBeSetTarget(arg_0));
            }
        }
    }
}

