/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.looted;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Obsidian_Horseshoe_Provider;
import com.sts15.fargos.items.providers.Soul_of_Colossus_Provider;
import com.sts15.fargos.network.NetworkHandler;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class ObsidianHorseshoeItem
extends TalismanItem
implements Obsidian_Horseshoe_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    private static final String charmName = "obsidian_horseshoe";

    public ObsidianHorseshoeItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.obsidian_horseshoe").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!ObsidianHorseshoeItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (Exception e) {
            LOGGER.error("Error checking config status for obsidian_horseshoe", (Throwable)e);
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static final int MAX_SHIELD_TICKS = 200;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            int newTime;
            boolean startNormally;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag tag = player2.getPersistentData();
            boolean nowEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(s -> s.getItem() instanceof Obsidian_Horseshoe_Provider, (LivingEntity)player2).isPresent();
            boolean wasEquipped = tag.getBoolean("HorseshoeEquipped");
            boolean hasSoulEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(s -> s.getItem() instanceof Soul_of_Colossus_Provider, (LivingEntity)player2).isPresent();
            if (hasSoulEquipped) {
                if (tag.contains("FireShieldDuration")) {
                    tag.remove("FireShieldDuration");
                    tag.remove("WasInLava");
                    NetworkHandler.sendSyncFireShieldToClient(player2, 0);
                }
                tag.putBoolean("HorseshoeEquipped", false);
                return;
            }
            if (!nowEquipped || !ObsidianHorseshoeItem.checkConfigEnabledStatus()) {
                if (tag.contains("FireShieldDuration")) {
                    tag.remove("FireShieldDuration");
                    tag.remove("WasInLava");
                    NetworkHandler.sendSyncFireShieldToClient(player2, 0);
                }
                tag.putBoolean("HorseshoeEquipped", false);
                return;
            }
            if (!TalismanUtil.isTalismanEnabled(player2, ObsidianHorseshoeItem.charmName)) {
                return;
            }
            if (nowEquipped && !wasEquipped) {
                tag.putInt("FireShieldDuration", 0);
                tag.putBoolean("WasInLava", player2.isInLava() || player2.isOnFire());
                NetworkHandler.sendSyncFireShieldToClient(player2, 0);
            }
            tag.putBoolean("HorseshoeEquipped", nowEquipped);
            int oldTime = tag.contains("FireShieldDuration") ? tag.getInt("FireShieldDuration") : -1;
            boolean nowHot = player2.isInLava() || player2.isOnFire();
            boolean wasHot = tag.getBoolean("WasInLava");
            boolean bl = startNormally = nowHot && !wasHot && !tag.contains("FireShieldDuration");
            if (tag.contains("FireShieldDuration") || startNormally) {
                int ticks;
                int n = ticks = tag.contains("FireShieldDuration") ? tag.getInt("FireShieldDuration") : 200;
                if (nowHot) {
                    if (ticks > 0) {
                        --ticks;
                    }
                } else {
                    ticks = Math.min(ticks + 1, 200);
                }
                if (!nowHot && ticks >= 200) {
                    tag.remove("FireShieldDuration");
                    tag.remove("WasInLava");
                    ticks = -1;
                } else {
                    tag.putInt("FireShieldDuration", ticks);
                    tag.putBoolean("WasInLava", nowHot);
                }
            }
            if ((newTime = tag.contains("FireShieldDuration") ? tag.getInt("FireShieldDuration") : 0) != (oldTime < 0 ? 0 : oldTime)) {
                NetworkHandler.sendSyncFireShieldToClient(player2, newTime);
            }
        }

        @SubscribeEvent
        public static void onPlayerHurt(LivingIncomingDamageEvent event) {
            boolean isFire;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            boolean hasEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(s -> s.getItem() instanceof Obsidian_Horseshoe_Provider, (LivingEntity)player).isPresent();
            if (!hasEquipped || !ObsidianHorseshoeItem.checkConfigEnabledStatus()) {
                return;
            }
            if (!TalismanUtil.isTalismanEnabled(player, ObsidianHorseshoeItem.charmName)) {
                return;
            }
            if (event.getSource().is(DamageTypes.HOT_FLOOR)) {
                BlockPos below = player.blockPosition().below();
                if (player.level().getBlockState(below).is(Blocks.MAGMA_BLOCK)) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                    return;
                }
            }
            boolean hasSoulEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(s -> s.getItem() instanceof Soul_of_Colossus_Provider, (LivingEntity)player).isPresent();
            boolean bl = isFire = event.getSource().is(DamageTypes.IN_FIRE) || event.getSource().is(DamageTypes.ON_FIRE) || event.getSource().is(DamageTypes.LAVA);
            if (isFire) {
                if (hasSoulEquipped) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                } else if (player.getPersistentData().getInt("FireShieldDuration") > 0) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                }
            }
        }
    }
}

