/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.scavenged;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Amber_Horseshoe_Balloon_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class AmberHorseshoeBalloonItem
extends TalismanItem
implements ICurioItem,
Amber_Horseshoe_Balloon_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    public static final String charmName = "amber_horseshoe_balloon";

    public AmberHorseshoeBalloonItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.amber_horseshoe_balloon").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!AmberHorseshoeBalloonItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for amber_horseshoe_balloon");
            return true;
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onIncomingDamage(LivingIncomingDamageEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            DamageSource source = event.getSource();
            ResourceKey fallDamageType = DamageTypes.FALL;
            if (source.is(fallDamageType)) {
                float damage;
                boolean equipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Amber_Horseshoe_Balloon_Provider, (LivingEntity)player).isPresent();
                boolean enabled = TalismanUtil.isTalismanEnabled(player, AmberHorseshoeBalloonItem.charmName);
                if (equipped && enabled && (damage = event.getAmount()) > 4.0f) {
                    event.setAmount(4.0f);
                }
            }
        }
    }
}

