/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.scavenged;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Bundle_Of_Horseshoe_Balloons_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BundleOfHorseshoeBalloonsItem
extends TalismanItem
implements ICurioItem,
Bundle_Of_Horseshoe_Balloons_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    public static final String charmName = "bundle_of_horseshoe_balloons";
    private static final ResourceLocation SAFE_FALL_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"fargos", (String)"bundle_horseshoe_safe_fall_boost");
    private static final AttributeModifier SAFE_FALL_MODIFIER = new AttributeModifier(SAFE_FALL_MODIFIER_ID, 6.0, AttributeModifier.Operation.ADD_VALUE);

    public BundleOfHorseshoeBalloonsItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.bundle_of_horseshoe_balloons").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!BundleOfHorseshoeBalloonsItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("Error checking config status for bundle_of_horseshoe_balloons");
            return true;
        }
    }

    private static void applyFallBoost(Player player) {
        AttributeInstance attr = player.getAttribute(Attributes.SAFE_FALL_DISTANCE);
        if (attr != null && attr.getModifier(SAFE_FALL_MODIFIER_ID) == null) {
            attr.addTransientModifier(SAFE_FALL_MODIFIER);
        }
    }

    private static void removeFallBoost(Player player) {
        AttributeInstance attr = player.getAttribute(Attributes.SAFE_FALL_DISTANCE);
        if (attr != null && attr.getModifier(SAFE_FALL_MODIFIER_ID) != null) {
            attr.removeModifier(SAFE_FALL_MODIFIER);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean equipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Bundle_Of_Horseshoe_Balloons_Provider, (LivingEntity)player2).isPresent();
            boolean enabled = TalismanUtil.isTalismanEnabled(player2, BundleOfHorseshoeBalloonsItem.charmName);
            if (equipped && enabled) {
                BundleOfHorseshoeBalloonsItem.applyFallBoost((Player)player2);
            } else {
                BundleOfHorseshoeBalloonsItem.removeFallBoost((Player)player2);
            }
        }
    }
}

