/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.scavenged;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Flying_Carpet_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class FlyingCarpetItem
extends TalismanItem
implements ICurioItem,
Flying_Carpet_Provider {
    public static final String charmName = "flying_carpet";

    public FlyingCarpetItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.flying_carpet").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!FlyingCarpetItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (Exception e) {
            return true;
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.onGround() || !player2.isShiftKeyDown()) {
                return;
            }
            boolean equipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Flying_Carpet_Provider, (LivingEntity)player2).isPresent();
            boolean enabled = TalismanUtil.isTalismanEnabled(player2, FlyingCarpetItem.charmName);
            if (!equipped || !enabled) {
                return;
            }
            if (player2.getDeltaMovement().y < 0.0) {
                Vec3 motion = player2.getDeltaMovement();
                double newY = -0.001;
                Vec3 newMotion = new Vec3(motion.x * 0.99, newY, motion.z * 0.99);
                player2.setDeltaMovement(newMotion);
                player2.fallDistance = 0.0f;
                player2.hasImpulse = true;
                player2.hurtMarked = true;
            }
        }
    }
}

