/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.scavenged;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Shield_Of_Cthulhu_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ShieldOfCthulhuItem
extends TalismanItem
implements ICurioItem,
Shield_Of_Cthulhu_Provider {
    private static final Logger LOGGER = LogManager.getLogger((String)"fargostalismans");
    public static final String charmName = "shield_of_cthulhu";

    public ShieldOfCthulhuItem() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.shield_of_cthulhu").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!ShieldOfCthulhuItem.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        try {
            String fieldName = charmName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            return (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (Exception e) {
            LOGGER.error("Error checking config status for shield_of_cthulhu");
            return true;
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerHit(LivingIncomingDamageEvent event) {
            double dz;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.level().isClientSide) {
                return;
            }
            Entity attacker = event.getSource().getEntity();
            if (!(attacker instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingAttacker = (LivingEntity)attacker;
            boolean equipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Shield_Of_Cthulhu_Provider, (LivingEntity)player).isPresent();
            boolean enabled = TalismanUtil.isTalismanEnabled(player, ShieldOfCthulhuItem.charmName);
            if (!(equipped && enabled && player.isSprinting())) {
                return;
            }
            double dx = attacker.getX() - player.getX();
            double magnitude = Math.sqrt(dx * dx + (dz = attacker.getZ() - player.getZ()) * dz);
            if (magnitude < 0.01) {
                return;
            }
            double launchStrength = 1.5;
            double upwardStrength = 0.5;
            attacker.push((dx /= magnitude) * launchStrength, upwardStrength, (dz /= magnitude) * launchStrength);
            attacker.hurtMarked = true;
            float damage = 4.0f;
            attacker.hurt(player.damageSources().playerAttack((Player)player), damage);
        }
    }
}

