/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.souls;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Brain_Of_Confusion_Provider;
import com.sts15.fargos.items.providers.Charm_of_Myths_Provider;
import com.sts15.fargos.items.providers.Frozen_Shield_Provider;
import com.sts15.fargos.items.providers.Hero_Shield_Provider;
import com.sts15.fargos.items.providers.Obsidian_Horseshoe_Provider;
import com.sts15.fargos.items.providers.Shiny_Stone_Provider;
import com.sts15.fargos.items.providers.Soul_of_Colossus_Provider;
import com.sts15.fargos.items.providers.Star_Veil_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Soul_of_Colossus
extends TalismanItem
implements ICurioItem,
Soul_of_Colossus_Provider,
Shiny_Stone_Provider,
Frozen_Shield_Provider,
Charm_of_Myths_Provider,
Brain_Of_Confusion_Provider,
Obsidian_Horseshoe_Provider,
Star_Veil_Provider,
Hero_Shield_Provider {
    public static final String talismanName = "soul_of_colossus";
    private static final ResourceLocation HEALTH_BOOST_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"soul_of_colossus_health_boost");
    private static final ResourceLocation HEALTH_DATA_KEY = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"soul_of_colossus_health");

    public Soul_of_Colossus() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    private static double getHealthMultiplier() {
        return (Double)Config.SOUL_OF_COLOSSUS_HEALTH_MULTIPLIER.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.soul_of_colossus").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Soul_of_Colossus.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        if (Screen.hasShiftDown()) {
            if (Screen.hasShiftDown()) {
                this.addTrinketTooltip(tooltipComponents, "ankh_shield", 4886754);
                this.addTrinketTooltip(tooltipComponents, "shiny_stone", 0xFFAA00);
                this.addTrinketTooltip(tooltipComponents, "pocket_mirror", 58082);
                this.addTrinketTooltip(tooltipComponents, "hand_warmer", 0xFF5555);
                this.addTrinketTooltip(tooltipComponents, "frozen_shield", 49151);
                this.addTrinketTooltip(tooltipComponents, "worm_scarf", 9127187);
                this.addTrinketTooltip(tooltipComponents, "charm_of_myths", 0xAA55FF);
                this.addTrinketTooltip(tooltipComponents, "brain_of_confusion", 0xFF66CC);
                this.addTrinketTooltip(tooltipComponents, "obsidian_horseshoe", 8339391);
                this.addTrinketTooltip(tooltipComponents, "bee_cloak", 0xFFDD44);
                this.addTrinketTooltip(tooltipComponents, "star_veil", 0xFF77FF);
                this.addTrinketTooltip(tooltipComponents, "hero_shield", 0xFFCC33);
            }
        } else {
            tooltipComponents.add((Component)Component.literal((String)"Hold ").append((Component)Component.literal((String)"[LShift]").withStyle(ChatFormatting.GRAY)).append(" to see each trinket effect").withStyle(ChatFormatting.DARK_GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private void addTrinketTooltip(List<Component> tooltip, String key, int hexColor) {
        MutableComponent name = Component.translatable((String)("item.fargostalismans." + key)).setStyle(Style.EMPTY.withColor(hexColor));
        MutableComponent effect = Component.translatable((String)("item.fargostalismans.tooltip." + key)).setStyle(Style.EMPTY.withColor(0xAAAAAA));
        tooltip.add((Component)Component.literal((String)" - ").append((Component)name).append(": ").append((Component)effect));
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    public static void resetHealth(Player player) {
        AttributeInstance healthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        if (healthAttribute != null && healthAttribute.getModifier(HEALTH_BOOST_ID) != null) {
            healthAttribute.removeModifier(HEALTH_BOOST_ID);
        }
    }

    public static void increaseHealth(Player player) {
        AttributeInstance healthAttribute = player.getAttribute(Attributes.MAX_HEALTH);
        if (healthAttribute != null && healthAttribute.getModifier(HEALTH_BOOST_ID) == null) {
            AttributeModifier modifier = new AttributeModifier(HEALTH_BOOST_ID, Soul_of_Colossus.getHealthMultiplier(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            healthAttribute.addTransientModifier(modifier);
        }
    }

    private static void negateNegativeEffects(Player player) {
        if (((Boolean)Config.SOUL_OF_COLOSSUS_REMOVE_NEGATIVE_EFFECTS.get()).booleanValue()) {
            List<MobEffectInstance> negativeEffects = player.getActiveEffects().stream().filter(effectInstance -> {
                MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                return !effect.isBeneficial() && !effect.equals(MobEffects.BAD_OMEN);
            }).toList();
            for (MobEffectInstance effect : negativeEffects) {
                player.removeEffect(effect.getEffect());
            }
        }
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        Soul_of_Colossus.increaseHealth(entity);
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        boolean hasSoulOfColossusEffect = entity.hasEffect(EffectsInit.SOUL_OF_COLOSSUS_EFFECT);
        if (!hasSoulOfColossusEffect) {
            Soul_of_Colossus.resetHealth(entity);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (!TalismanUtil.isTalismanEnabled(player2, "Soul_of_Colossus")) {
                Soul_of_Colossus.resetHealth((Player)player2);
            }
            if (player2.hasEffect(EffectsInit.SOUL_OF_COLOSSUS_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Soul_of_Colossus_Provider, (LivingEntity)player2).isPresent()) {
                if (!TalismanUtil.isTalismanEnabled(player2, Soul_of_Colossus.talismanName)) {
                    return;
                }
                Soul_of_Colossus.negateNegativeEffects((Player)player2);
                if (++tickCounter < 10) {
                    return;
                }
                tickCounter = 0;
                Soul_of_Colossus.increaseHealth((Player)player2);
            } else {
                if (++tickCounter < 10) {
                    return;
                }
                tickCounter = 0;
                Soul_of_Colossus.resetHealth((Player)player2);
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            boolean hasEquippedCurio = CuriosApi.getCuriosHelper().findEquippedCurio(equippedStack -> equippedStack.getItem() instanceof Soul_of_Colossus_Provider, (LivingEntity)player2).isPresent();
            boolean hasSoulOfColossusEffect = player2.hasEffect(EffectsInit.SOUL_OF_COLOSSUS_EFFECT);
            if (hasSoulOfColossusEffect || hasEquippedCurio) {
                player2.getPersistentData().putFloat(HEALTH_DATA_KEY.toString(), player2.getHealth());
            }
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.getPersistentData().contains(HEALTH_DATA_KEY.toString())) {
                boolean hasEquippedCurio = CuriosApi.getCuriosHelper().findEquippedCurio(equippedStack -> equippedStack.getItem() instanceof Soul_of_Colossus_Provider, (LivingEntity)player2).isPresent();
                boolean hasSoulOfColossusEffect = player2.hasEffect(EffectsInit.SOUL_OF_COLOSSUS_EFFECT);
                if (hasSoulOfColossusEffect || hasEquippedCurio) {
                    Soul_of_Colossus.increaseHealth((Player)player2);
                    player2.setHealth(player2.getPersistentData().getFloat(HEALTH_DATA_KEY.toString()));
                }
                player2.getPersistentData().remove(HEALTH_DATA_KEY.toString());
            }
        }
    }
}

