/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.souls;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Aeolus_Boots_Provider;
import com.sts15.fargos.items.providers.Amber_Horseshoe_Balloon_Provider;
import com.sts15.fargos.items.providers.Ancient_Horn_Provider;
import com.sts15.fargos.items.providers.Blessed_Apple_Provider;
import com.sts15.fargos.items.providers.Brain_Scrambler_Provider;
import com.sts15.fargos.items.providers.Bundle_Of_Horseshoe_Balloons_Provider;
import com.sts15.fargos.items.providers.Flying_Carpet_Provider;
import com.sts15.fargos.items.providers.Master_Ninja_Gear_Provider;
import com.sts15.fargos.items.providers.Mechanical_Cart_Provider;
import com.sts15.fargos.items.providers.Reindeer_Bells_Provider;
import com.sts15.fargos.items.providers.Shield_Of_Cthulhu_Provider;
import com.sts15.fargos.items.providers.Soul_of_Supersonic_Provider;
import com.sts15.fargos.items.providers.Sweetheart_Necklace_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class Soul_of_Supersonic
extends TalismanItem
implements Soul_of_Supersonic_Provider,
Aeolus_Boots_Provider,
Brain_Scrambler_Provider,
Reindeer_Bells_Provider,
Ancient_Horn_Provider,
Mechanical_Cart_Provider,
Blessed_Apple_Provider,
Master_Ninja_Gear_Provider,
Shield_Of_Cthulhu_Provider,
Bundle_Of_Horseshoe_Balloons_Provider,
Amber_Horseshoe_Balloon_Provider,
Sweetheart_Necklace_Provider,
Flying_Carpet_Provider {
    private static final ResourceLocation WALK_SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"fargos", (String)"supersonic_walking_speed_boost");
    public static final String talismanName = "soul_of_supersonic";

    public Soul_of_Supersonic() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    private static double getWalkSpeedBoost() {
        return (Double)Config.SOUL_OF_SUPERSONIC_WALK_SPEED_MULTIPLIER.get();
    }

    private static double getFlySpeedBoost() {
        return (Double)Config.SOUL_OF_SUPERSONIC_FLY_SPEED_MULTIPLIER.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.soul_of_supersonic").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Soul_of_Supersonic.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        if (Screen.hasShiftDown()) {
            if (Screen.hasShiftDown()) {
                this.addTrinketTooltip(tooltipComponents, "aeolus_boots", 0x66CCFF);
                this.addTrinketTooltip(tooltipComponents, "brain_scrambler", 0xAA33CC);
                this.addTrinketTooltip(tooltipComponents, "reindeer_bells", 13922048);
                this.addTrinketTooltip(tooltipComponents, "ancient_horn", 10511658);
                this.addTrinketTooltip(tooltipComponents, "mechanical_cart", 0x999999);
                this.addTrinketTooltip(tooltipComponents, "blessed_apple", 0xFFCC00);
                this.addTrinketTooltip(tooltipComponents, "master_ninja_gear", 0x3A3A3A);
                this.addTrinketTooltip(tooltipComponents, "shield_of_cthulhu", 0x990000);
                this.addTrinketTooltip(tooltipComponents, "bundle_of_horseshoe_balloons", 39372);
                this.addTrinketTooltip(tooltipComponents, "amber_horseshoe_balloon", 0xFFAA00);
                this.addTrinketTooltip(tooltipComponents, "sweetheart_necklace", 0xFF6699);
                this.addTrinketTooltip(tooltipComponents, "flying_carpet", 12155479);
            }
        } else {
            tooltipComponents.add((Component)Component.literal((String)"Hold ").append((Component)Component.literal((String)"[LShift]").withStyle(ChatFormatting.GRAY)).append(" to see each trinket effect").withStyle(ChatFormatting.DARK_GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private void addTrinketTooltip(List<Component> tooltip, String key, int hexColor) {
        MutableComponent name = Component.translatable((String)("item.fargostalismans." + key)).setStyle(Style.EMPTY.withColor(hexColor));
        MutableComponent effect = Component.translatable((String)("item.fargostalismans.tooltip." + key)).setStyle(Style.EMPTY.withColor(0xAAAAAA));
        tooltip.add((Component)Component.literal((String)" - ").append((Component)name).append(": ").append((Component)effect));
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    private static void applyEffects(Player player, CompoundTag playerData) {
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && speedAttribute.getModifier(WALK_SPEED_MODIFIER_ID) == null) {
            AttributeModifier modifier = new AttributeModifier(WALK_SPEED_MODIFIER_ID, Soul_of_Supersonic.getWalkSpeedBoost(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            speedAttribute.addTransientModifier(modifier);
        }
        if (!playerData.getBoolean("SoulOfSupersonicFlyingSpeedBoost")) {
            player.getAbilities().setFlyingSpeed((float)((double)player.getAbilities().getFlyingSpeed() * Soul_of_Supersonic.getFlySpeedBoost()));
            playerData.putBoolean("SoulOfSupersonicFlyingSpeedBoost", true);
        }
        playerData.putBoolean("SoulOfSupersonicActive", true);
        player.onUpdateAbilities();
    }

    private static void removeEffects(Player player, CompoundTag playerData) {
        AttributeModifier modifier;
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && (modifier = speedAttribute.getModifier(WALK_SPEED_MODIFIER_ID)) != null) {
            speedAttribute.removeModifier(modifier);
        }
        if (playerData.getBoolean("SoulOfSupersonicFlyingSpeedBoost")) {
            double flySpeedBoost = Soul_of_Supersonic.getFlySpeedBoost();
            player.getAbilities().setFlyingSpeed((float)((double)player.getAbilities().getFlyingSpeed() / flySpeedBoost));
            playerData.remove("SoulOfSupersonicFlyingSpeedBoost");
        }
        playerData.remove("SoulOfSupersonicActive");
        player.onUpdateAbilities();
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        if (TalismanUtil.isTalismanEnabled(entity, talismanName)) {
            Soul_of_Supersonic.applyEffects(entity, entity.getPersistentData());
            entity.sendSystemMessage((Component)Component.literal((String)"[").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)).append((Component)Component.translatable((String)"item.fargostalismans.soul_of_supersonic").setStyle(Style.EMPTY.withColor(ChatFormatting.RED))).append((Component)Component.literal((String)"] ").setStyle(Style.EMPTY.withColor(ChatFormatting.RED))).append((Component)Component.translatable((String)"key.categories.fargostalismans.fov").setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE))));
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        Soul_of_Supersonic.removeEffects(entity, entity.getPersistentData());
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag playerData = player2.getPersistentData();
            int tickCounter = playerData.getInt("SoulOfSupersonicTickCounter");
            if (++tickCounter < 10) {
                playerData.putInt("SoulOfSupersonicTickCounter", tickCounter);
                return;
            }
            playerData.putInt("SoulOfSupersonicTickCounter", 0);
            boolean isEnabledInConfig = TalismanUtil.isTalismanEnabled(player2, Soul_of_Supersonic.talismanName);
            boolean isEquipped = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Soul_of_Supersonic_Provider, (LivingEntity)player2).isPresent();
            boolean hasEffect = player2.hasEffect(EffectsInit.SOUL_OF_SUPERSONIC_EFFECT);
            boolean shouldBeActive = isEnabledInConfig && (isEquipped || hasEffect);
            boolean isCurrentlyActive = playerData.getBoolean("SoulOfSupersonicActive");
            if (shouldBeActive && !isCurrentlyActive) {
                Soul_of_Supersonic.applyEffects((Player)player2, playerData);
            } else if (!shouldBeActive && isCurrentlyActive) {
                Soul_of_Supersonic.removeEffects((Player)player2, playerData);
            }
        }
    }
}

