/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Battle_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;

public class Battle_Talisman
extends TalismanItem
implements Battle_Talisman_Provider {
    private static final String talismanName = "battle_talisman";
    private static final boolean isDebug = false;
    private static final Map<UUID, Integer> invinciblePlayers = new HashMap<UUID, Integer>();
    private static final Logger LOGGER = LogManager.getLogger();

    public Battle_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.battle_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Battle_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingIncomingDamageEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.hasEffect(EffectsInit.BATTLE_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Battle_Talisman_Provider, (LivingEntity)player).isPresent()) {
                if (!TalismanUtil.isTalismanEnabled(player, Battle_Talisman.talismanName)) {
                    return;
                }
                UUID playerUUID = player.getUUID();
                Integer invincibilityTicks = invinciblePlayers.get(playerUUID);
                if (invincibilityTicks == null || invincibilityTicks <= 0) {
                    invinciblePlayers.put(playerUUID, Config.BATTLE_TALISMAN_INVINCIBILITY_TICKS.getAsInt());
                } else {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            UUID playerUUID = player.getUUID();
            if (invinciblePlayers.containsKey(playerUUID)) {
                int ticks = invinciblePlayers.get(playerUUID);
                if (ticks > 0) {
                    invinciblePlayers.put(playerUUID, ticks - 1);
                } else {
                    invinciblePlayers.remove(playerUUID);
                }
            }
        }
    }
}

