/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Blaze_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Blaze_Talisman
extends TalismanItem
implements Blaze_Talisman_Provider {
    private static final String talismanName = "blaze_talisman";

    public Blaze_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.blaze_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Blaze_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    private static boolean canSee(Player player, Entity target) {
        Vec3 playerEye = player.getEyePosition(1.0f);
        Vec3 targetPos = target.position();
        BlockHitResult result = player.level().clip(new ClipContext(playerEye, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return result.getType() == HitResult.Type.MISS;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            ServerPlayer player;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && ((player = (ServerPlayer)player2).hasEffect(EffectsInit.BLAZE_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Blaze_Talisman_Provider, (LivingEntity)player).isPresent())) {
                if (!TalismanUtil.isTalismanEnabled(player, Blaze_Talisman.talismanName)) {
                    return;
                }
                int radius = Config.BLAZE_TALISMAN_BURN_RANGE.getAsInt();
                AABB area = player.getBoundingBox().inflate((double)radius);
                List mobs = player.level().getEntitiesOfClass(Monster.class, area);
                for (Monster mob : mobs) {
                    if (!Blaze_Talisman.canSee((Player)player, (Entity)mob)) continue;
                    mob.igniteForSeconds((float)Config.BLAZE_TALISMAN_BURN_TIME.getAsInt());
                }
            }
        }
    }
}

