/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Emerald_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Emerald_Talisman
extends TalismanItem
implements Emerald_Talisman_Provider {
    private static final String talismanName = "emerald_talisman";

    public Emerald_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.emerald_talisman", (Object[])new Object[]{(int)(Config.EMERALD_TALISMAN_INCREASED_ILLAGER_DAMAGE.getAsDouble() * 100.0)}).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Emerald_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingIncomingDamageEvent event) {
            ServerPlayer player;
            Entity source = event.getSource().getDirectEntity();
            if (source instanceof ServerPlayer && ((player = (ServerPlayer)source).hasEffect(EffectsInit.EMERALD_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Emerald_Talisman_Provider, (LivingEntity)player).isPresent())) {
                if (!TalismanUtil.isTalismanEnabled(player, Emerald_Talisman.talismanName)) {
                    return;
                }
                if (!(event.getSource().getEntity() instanceof Player)) {
                    return;
                }
                if (event.getEntity() instanceof AbstractIllager) {
                    event.setAmount(event.getAmount() * (1.0f + ((Double)Config.EMERALD_TALISMAN_INCREASED_ILLAGER_DAMAGE.get()).floatValue()));
                }
            }
        }
    }
}

