/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.network.packet;

import com.sts15.fargos.config.ServerConfig;
import com.sts15.fargos.config.ServerDataHandler;
import com.sts15.fargos.network.NetworkHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerTalismanConfigPacket
implements CustomPacketPayload {
    private final String playerUUID;
    private final Map<String, Boolean> talismanStates;
    public static final CustomPacketPayload.Type<ServerTalismanConfigPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"server_talisman_config"));
    public static final StreamCodec<FriendlyByteBuf, ServerTalismanConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerTalismanConfigPacket::getPlayerUUID, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.BOOL), ServerTalismanConfigPacket::getTalismanStates, ServerTalismanConfigPacket::new);

    public ServerTalismanConfigPacket(String playerUUID, Map<String, Boolean> talismanStates) {
        this.playerUUID = playerUUID;
        this.talismanStates = talismanStates;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public String getPlayerUUID() {
        return this.playerUUID;
    }

    public Map<String, Boolean> getTalismanStates() {
        return this.talismanStates;
    }

    public static void handle(ServerTalismanConfigPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HashMap<String, Boolean> talismanStates = new HashMap<String, Boolean>(ServerConfig.talismanEnabledStates);
            NetworkHandler.sendServerTalismanConfigToClient(serverPlayer, UUID.fromString(packet.playerUUID), talismanStates);
        } else if (context.player().level().isClientSide()) {
            Minecraft.getInstance().execute(() -> {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null && player.getUUID().toString().equals(packet.playerUUID)) {
                    ServerDataHandler.setServerTalismanStates(packet.getTalismanStates());
                    ServerDataHandler.saveServerTalismanStatesToPlayer(player);
                }
            });
        }
    }
}

