/*
 * Decompiled with CFR 0.152.
 */
package net.dnlayu.fastboot.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FastBoot");

    public void onLoad(String mixinPackage) {
        System.out.println("=== FastBoot Mixin Plugin onLoad called ===");
        LOGGER.info("FastBoot Mixin Plugin loaded from package: {}", (Object)mixinPackage);
    }

    public String getRefMapperConfig() {
        return "fastboot.refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        LOGGER.debug("Checking if mixin {} should be applied to {}", (Object)mixinClassName, (Object)targetClassName);
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        mixins.add("DataFixerMixin");
        mixins.add("DataFixersInitMixin");
        mixins.add("SharedConstantsMixin");
        LOGGER.info("Providing mixins: {}", mixins);
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        LOGGER.debug("Pre-applying mixin: {} to {}", (Object)mixinClassName, (Object)targetClassName);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        LOGGER.info("Successfully applied mixin: {} to {}", (Object)mixinClassName, (Object)targetClassName);
    }
}

