/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar;

import com.mojang.datafixers.util.Pair;
import java.util.BitSet;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class Badges {
    public static final ResourceLocation FONT = new FiguraIdentifier("badges");

    public static Component fetchBadges(UUID id) {
        int i;
        if (PermissionManager.get(id).getCategory() == Permissions.Category.BLOCKED) {
            return Component.empty();
        }
        Pair<BitSet, BitSet> pair = AvatarManager.getBadges(id);
        if (pair == null) {
            return Component.empty();
        }
        MutableComponent badges = Component.empty().withStyle(Style.EMPTY.withFont(FONT).withColor(ChatFormatting.WHITE).withObfuscated(Boolean.valueOf(false)));
        Avatar avatar = AvatarManager.getAvatarForPlayer(id);
        if (avatar != null) {
            if (!avatar.loaded) {
                badges.append((Component)Component.literal((String)Integer.toHexString(Math.abs(FiguraMod.ticks) % 16)));
            } else if (avatar.nbt != null) {
                block20: {
                    BitSet prideSet = (BitSet)pair.getFirst();
                    Pride[] pride = Pride.values();
                    for (i = pride.length - 1; i >= 0; --i) {
                        if (!prideSet.get(i)) continue;
                        badges.append(pride[i].badge);
                        break block20;
                    }
                    badges.append((Component)System.DEFAULT.badge.copy().withStyle(Style.EMPTY.withColor(ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.color)))));
                }
                if (avatar.scriptError) {
                    if (avatar.errorText == null) {
                        badges.append(System.ERROR.badge);
                    } else {
                        badges.append((Component)System.ERROR.badge.copy().withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)System.ERROR.desc.copy().append("\n\n").append(avatar.errorText)))));
                    }
                }
                if (avatar.versionStatus > 0) {
                    badges.append(System.WARNING.badge);
                }
                if (!avatar.noPermissions.isEmpty()) {
                    MutableComponent badge = System.PERMISSIONS.badge.copy();
                    MutableComponent desc = System.PERMISSIONS.desc.copy().append("\n");
                    for (Permissions t : avatar.noPermissions) {
                        desc.append("\n\u2022 ").append((Component)FiguraText.of("badges.no_permissions." + t.name.toLowerCase(Locale.US)));
                    }
                    badges.append((Component)badge.withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)desc))));
                }
            }
        }
        if (avatar != null) {
            BitSet specialSet = (BitSet)pair.getSecond();
            Special[] specialValues = Special.values();
            for (i = specialValues.length - 1; i >= 0; --i) {
                if (!specialSet.get(i)) continue;
                Special special = specialValues[i];
                Integer color = special.color;
                if (avatar.badgeToColor.containsKey(special.name().toLowerCase(Locale.US))) {
                    color = ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.badgeToColor.get(special.name().toLowerCase(Locale.US))));
                }
                Component badge = color != null ? special.badge.copy().withStyle(Style.EMPTY.withColor(color.intValue())) : special.badge;
                badges.append(badge);
            }
        }
        if (avatar != null && ((Boolean)Configs.SOUND_BADGE.value).booleanValue()) {
            if (avatar.lastPlayingSound > 0) {
                badges.append(System.SOUND.badge);
            } else if (SoundAPI.getSoundEngine().figura$isPlaying(id)) {
                avatar.lastPlayingSound = 20;
                badges.append(System.SOUND.badge);
            }
        }
        return badges;
    }

    public static Component noBadges4U(Component text) {
        return TextUtils.replaceInText((FormattedText)text, "[-*/+=\u2757\u274c\ud83d\udee1\u2605\u2606\u2764\u6587\u2712\ud83d\uddff0-9a-f]", TextUtils.UNKNOWN, (s, style) -> style.getFont().equals((Object)FONT) || style.getFont().equals((Object)UIHelper.UI_FONT), Integer.MAX_VALUE);
    }

    public static Pair<BitSet, BitSet> emptyBadges() {
        return Pair.of((Object)new BitSet(Pride.values().length), (Object)new BitSet(Special.values().length));
    }

    public static boolean hasCustomBadges(Component text) {
        return text.visit((style, string) -> string.contains("${badges}") || string.contains("${segdab}") ? FormattedText.STOP_ITERATION : Optional.empty(), Style.EMPTY).isPresent();
    }

    public static Component appendBadges(Component text, UUID id, boolean allow) {
        MutableComponent badges = allow ? Badges.fetchBadges(id) : Component.empty();
        boolean custom = Badges.hasCustomBadges(text);
        if (!custom) {
            return badges.getString().isBlank() ? text : text.copy().append(" ").append((Component)badges);
        }
        text = TextUtils.replaceInText((FormattedText)text, "\\$\\{badges\\}(?s)", badges);
        text = TextUtils.replaceInText((FormattedText)text, "\\$\\{segdab\\}(?s)", TextUtils.reverse((FormattedText)badges));
        return text;
    }

    public static enum Pride {
        AGENDER("\u16a0"),
        AROACE("\u16a1"),
        AROMANTIC("\u16a2"),
        ASEXUAL("\u16a3"),
        BIGENDER("\u16a4"),
        BISEXUAL("\u16a5"),
        DEMIBOY("\u16a6"),
        DEMIGENDER("\u16a7"),
        DEMIGIRL("\u16a8"),
        DEMIROMANTIC("\u16a9"),
        DEMISEXUAL("\u16aa"),
        DISABILITY("\u16ab"),
        FINSEXUAL("\u16ac"),
        GAYMEN("\u16ad"),
        GENDERFAE("\u16ae"),
        GENDERFLUID("\u16af"),
        GENDERQUEER("\u16b0"),
        INTERSEX("\u16b1"),
        LESBIAN("\u16b2"),
        NONBINARY("\u16b3"),
        PANSEXUAL("\u16b4"),
        PLURAL("\u16b5"),
        POLYSEXUAL("\u16b6"),
        PRIDE("\u16b7"),
        TRANSGENDER("\u16b8");

        public final Component badge;
        public final Component desc = FiguraText.of("badges.pride." + this.name().toLowerCase(Locale.US));

        private Pride(String unicode) {
            this.badge = Component.literal((String)unicode).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)this.desc)));
        }
    }

    public static enum System {
        DEFAULT("\u25b3"),
        PERMISSIONS("\ud83d\udee1"),
        WARNING("\u2757"),
        ERROR("\u274c"),
        SOUND("\ud83d\udd0a");

        public final Component badge;
        public final Component desc = FiguraText.of("badges.system." + this.name().toLowerCase(Locale.US));

        private System(String unicode) {
            this.badge = Component.literal((String)unicode).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)this.desc)));
        }
    }

    public static enum Special {
        DEV("\u2605"),
        DISCORD_STAFF("\u2606", ColorUtils.Colors.DISCORD.hex),
        CONTEST("\u2606", ColorUtils.Colors.AWESOME_BLUE.hex),
        DONATOR("\u2764", ColorUtils.Colors.AWESOME_BLUE.hex),
        TRANSLATOR("\u6587"),
        TEXTURE_ARTIST("\u2712"),
        IMMORTALIZED("\ud83d\uddff");

        public final Component badge;
        public final Component desc = FiguraText.of("badges.special." + this.name().toLowerCase(Locale.US));
        public final Integer color;

        private Special(String unicode) {
            this(unicode, null);
        }

        private Special(String unicode, Integer color) {
            Style style = Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)this.desc));
            if (color != null) {
                style = style.withColor(color.intValue());
            }
            this.color = color;
            this.badge = Component.literal((String)unicode).withStyle(style);
        }
    }
}

