/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.backend2.websocket;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketFrame;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.backend2.websocket.C2SMessageHandler;
import org.figuramc.figura.backend2.websocket.S2CMessageHandler;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.utils.FiguraText;

public class FiguraWebSocketAdapter
extends WebSocketAdapter {
    public static final Map<Integer, String> ERROR_CODES = new HashMap<Integer, String>(){
        {
            this.put(1000, "Normal Closure");
            this.put(1001, "Going Away");
            this.put(1002, "Protocol Error");
            this.put(1003, "Unsupported Data");
            this.put(1005, "No Status Received");
            this.put(1006, "Abnormal Closure");
            this.put(1007, "Invalid Frame Payload Data");
            this.put(1008, "Policy Violation");
            this.put(1009, "Message Too Big");
            this.put(1010, "Mandatory Ext.");
            this.put(1011, "Internal Error");
            this.put(1012, "Service Restart");
            this.put(1013, "Try Again Later");
            this.put(1014, "Bad Gateway");
            this.put(1015, "TLS Handshake");
            this.put(3000, "Unauthorized");
            this.put(4000, "Re-Auth");
            this.put(4001, "Banned");
            this.put(4002, "Too Many Connections");
        }
    };
    private final String token;

    public FiguraWebSocketAdapter(String token) {
        this.token = token;
    }

    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
        FiguraMod.LOGGER.info("Connecting to Figura ws backend (" + FiguraWebSocketAdapter.getBackendAddress() + ")");
        super.onConnected(websocket, headers);
        try {
            websocket.sendBinary(C2SMessageHandler.auth(this.token).array());
        }
        catch (Exception e) {
            this.handleClose(-1, e.getMessage());
        }
    }

    public static String getBackendAddress() {
        return "wss://" + FiguraWebSocketAdapter.getBackendAddressWithPort() + "/ws";
    }

    private static String getBackendAddressWithPort() {
        ServerAddress backendIP = ServerAddress.parseString((String)((String)Configs.SERVER_IP.value));
        boolean hasPort = ((String)Configs.SERVER_IP.value).matches("[^:]+:\\d+");
        if (hasPort) {
            try {
                return backendIP.getHost() + ":" + backendIP.getPort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return backendIP.getHost();
    }

    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws Exception {
        super.onBinaryMessage(websocket, binary);
        if (NetworkStuff.debug) {
            FiguraMod.debug("Received raw ws message of " + binary.length + "b", new Object[0]);
        }
        try {
            S2CMessageHandler.handle(ByteBuffer.wrap(binary));
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to handle ws message", (Throwable)e);
        }
    }

    public void onSendingHandshake(WebSocket websocket, String requestLine, List<String[]> headers) throws Exception {
        super.onSendingHandshake(websocket, requestLine, headers);
    }

    public void onTextMessage(WebSocket websocket, byte[] data) {
    }

    public void handleCallbackError(WebSocket websocket, Throwable cause) throws Exception {
        super.handleCallbackError(websocket, cause);
        FiguraMod.LOGGER.error("Failed to handle ws message", cause);
    }

    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean remote) throws Exception {
        super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, remote);
        String reason = serverCloseFrame.getCloseReason();
        if (reason == null) {
            reason = "Unknown!";
        }
        int code = serverCloseFrame.getCloseCode();
        reason = reason.trim().isEmpty() ? ERROR_CODES.getOrDefault(code, "Unknown") : reason;
        FiguraMod.LOGGER.info("Closed connection: " + reason + ", Code: " + code + ", Remote: " + remote);
        this.handleClose(code, reason + (String)(FiguraMod.debugModeEnabled() ? "\n\nCode: " + code + "\nRemote: " + remote : ""));
    }

    public void onSendingFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
        if (NetworkStuff.debug && frame.getPayload() != null) {
            FiguraMod.debug("Sent raw ws message of " + frame.getPayload().length + "b", new Object[0]);
        }
        super.onSendingFrame(websocket, frame);
    }

    private void handleClose(int code, String reason) {
        if (((Boolean)Configs.CONNECTION_TOASTS.value).booleanValue()) {
            FiguraToast.sendToast((Object)FiguraText.of("backend.disconnected"), FiguraToast.ToastType.ERROR);
        }
        NetworkStuff.disconnect(reason);
        if (code == 4000) {
            NetworkStuff.reAuth();
        }
    }
}

