/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraClientCommandSource;
import org.figuramc.figura.utils.FiguraText;

class LinkCommand {
    private static final List<FiguraMod.Links> LINKS = new ArrayList<FiguraMod.Links>(){
        {
            this.add(FiguraMod.Links.Wiki);
            this.add(FiguraMod.Links.Kofi);
            this.add(FiguraMod.Links.OpenCollective);
            this.add(null);
            this.add(FiguraMod.Links.Discord);
            this.add(FiguraMod.Links.Github);
            this.add(null);
            this.add(FiguraMod.Links.Modrinth);
            this.add(FiguraMod.Links.Curseforge);
        }
    };

    LinkCommand() {
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder links = LiteralArgumentBuilder.literal((String)"links");
        links.executes(context -> {
            MutableComponent message = Component.empty().withStyle(ColorUtils.Colors.AWESOME_BLUE.style).append((Component)Component.literal((String)"\u2022*+\u2022* ").append((Component)FiguraText.of()).append(" Links *\u2022+*\u2022").withStyle(ChatFormatting.UNDERLINE)).append("\n");
            for (FiguraMod.Links link : LINKS) {
                message.append("\n");
                if (link == null) continue;
                message.append((Component)Component.literal((String)("\u2022 [" + link.name() + "]")).withStyle(link.style).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link.url))).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)link.url)))));
            }
            FiguraMod.sendChatMessage((Component)message);
            return 1;
        });
        return links;
    }
}

