/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.config.ConfigKeyBind;
import org.figuramc.figura.config.ConfigManager;
import org.figuramc.figura.config.InputType;
import org.figuramc.figura.gui.screens.NetworkFilterScreen;
import org.figuramc.figura.lua.api.net.NetworkingAPI;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraText;

public abstract class ConfigType<T> {
    public final String id;
    public final boolean hidden;
    public Component name;
    public Component tooltip;
    public T value;
    public T tempValue;
    public final T defaultValue;
    public boolean disabled;

    public ConfigType(String name, T value) {
        this(name, value, false);
    }

    public ConfigType(String name, T value, boolean hidden) {
        this.id = name;
        this.hidden = hidden;
        name = "config." + (String)name;
        this.name = FiguraText.of((String)name);
        this.tooltip = FiguraText.of((String)name + ".tooltip");
        this.tempValue = value;
        this.defaultValue = this.tempValue;
        this.value = this.tempValue;
    }

    public abstract T parseValue(String var1);

    public void setValue(String newVal) {
        boolean change = !this.value.equals(this.tempValue);
        try {
            this.value = this.parseValue(newVal);
        }
        catch (Exception e) {
            FiguraMod.LOGGER.warn("Failed to set this config (" + this.id + ") value \"" + String.valueOf(this.value) + "\", restoring it to default", (Throwable)e);
            this.value = this.defaultValue;
            change = true;
        }
        this.tempValue = this.value;
        if (change) {
            try {
                this.onChange();
            }
            catch (Exception e) {
                FiguraMod.LOGGER.warn("Failed to run onChange for config \"" + this.id + "\"", (Throwable)e);
            }
        }
    }

    public void setTempValue(String newVal) {
        this.tempValue = this.parseValue(newVal);
    }

    public void discardConfig() {
        this.tempValue = this.value;
    }

    public void setDefault() {
        this.value = this.defaultValue;
    }

    public void resetTemp() {
        this.tempValue = this.defaultValue;
    }

    public boolean isDefault() {
        return this.defaultValue == null || this.defaultValue.equals(this.tempValue);
    }

    public void onChange() {
    }

    public static class NetworkFilterConfig
    extends ButtonConfig
    implements SerializableConfig {
        private final ArrayList<NetworkingAPI.Filter> filters = new ArrayList();

        public NetworkFilterConfig(String name, Category category) {
            super(name, category, () -> {
                Minecraft mc = Minecraft.getInstance();
                mc.setScreen((Screen)new NetworkFilterScreen(mc.screen));
            });
        }

        public ArrayList<NetworkingAPI.Filter> getFilters() {
            return this.filters;
        }

        @Override
        public JsonElement serialize() {
            JsonArray array = new JsonArray();
            for (NetworkingAPI.Filter filter : this.filters) {
                JsonObject o = new JsonObject();
                o.addProperty("source", filter.getSource());
                array.add((JsonElement)o);
            }
            return array;
        }

        @Override
        public void deserialize(JsonElement element) {
            this.filters.clear();
            if (!element.isJsonArray()) {
                return;
            }
            JsonArray array = element.getAsJsonArray();
            for (JsonElement e : array) {
                JsonPrimitive source;
                JsonObject o;
                JsonElement s;
                if (!e.isJsonObject() || (s = (o = e.getAsJsonObject()).get("source")) == null || !s.isJsonPrimitive() || !(source = s.getAsJsonPrimitive()).isString()) continue;
                this.filters.add(new NetworkingAPI.Filter(source.getAsString()));
            }
        }

        @Override
        public void setDefault() {
            this.filters.clear();
        }

        @Override
        public boolean isDefault() {
            return this.filters.size() == 0;
        }
    }

    public static class ButtonConfig
    extends ParentedConfig<Void> {
        public final Runnable toRun;

        public ButtonConfig(String name, Category category, Runnable toRun) {
            super(name, category, null);
            this.toRun = toRun;
        }

        @Override
        public Void parseValue(String newVal) {
            return null;
        }

        @Override
        public void setValue(String newVal) {
        }
    }

    public static class KeybindConfig
    extends ParentedConfig<String> {
        public ConfigKeyBind keyBind;

        public KeybindConfig(String name, Category category, String defaultValue) {
            super(name, category, defaultValue);
            this.keyBind = new ConfigKeyBind(this.name.getString(), InputConstants.getKey((String)defaultValue), this);
        }

        @Override
        public String parseValue(String newVal) {
            return newVal;
        }
    }

    public static class IPConfig
    extends InputConfig<String> {
        public IPConfig(String name, Category category, String defaultValue) {
            super(name, category, defaultValue, InputType.IP);
        }

        @Override
        public String parseValue(String newVal) {
            return newVal;
        }
    }

    public static class FolderConfig
    extends InputConfig<String> {
        public FolderConfig(String name, Category category, String defaultValue) {
            super(name, category, defaultValue, InputType.FOLDER_PATH);
        }

        @Override
        public String parseValue(String newVal) {
            return newVal;
        }
    }

    public static class ColorConfig
    extends InputConfig<Integer> {
        public ColorConfig(String name, Category category, int defaultValue) {
            super(name, category, Integer.valueOf(defaultValue), InputType.HEX_COLOR);
        }

        @Override
        public Integer parseValue(String newVal) {
            return Integer.parseInt(newVal);
        }

        @Override
        public void setTempValue(String newVal) {
            this.tempValue = ColorUtils.rgbToInt(ColorUtils.userInputHex(newVal, FiguraVec3.of()));
        }
    }

    public static class PositiveFloatConfig
    extends InputConfig<Float> {
        public PositiveFloatConfig(String name, Category category, float defaultValue) {
            super(name, category, Float.valueOf(defaultValue), InputType.POSITIVE_FLOAT);
        }

        @Override
        public Float parseValue(String newVal) {
            return Float.valueOf(Float.parseFloat(newVal));
        }
    }

    public static class PositiveIntConfig
    extends InputConfig<Integer> {
        public PositiveIntConfig(String name, Category category, int defaultValue) {
            super(name, category, Integer.valueOf(defaultValue), InputType.POSITIVE_INT);
        }

        @Override
        public Integer parseValue(String newVal) {
            return Integer.parseInt(newVal);
        }
    }

    public static class FloatConfig
    extends InputConfig<Float> {
        public FloatConfig(String name, Category category, float defaultValue) {
            super(name, category, Float.valueOf(defaultValue), InputType.FLOAT);
        }

        @Override
        public Float parseValue(String newVal) {
            return Float.valueOf(Float.parseFloat(newVal));
        }
    }

    public static class IntConfig
    extends InputConfig<Integer> {
        public IntConfig(String name, Category category, int defaultValue) {
            super(name, category, Integer.valueOf(defaultValue), InputType.INT);
        }

        @Override
        public Integer parseValue(String newVal) {
            return Integer.parseInt(newVal);
        }
    }

    public static class StringConfig
    extends InputConfig<String> {
        public StringConfig(String name, Category category, String defaultValue) {
            super(name, category, defaultValue, InputType.ANY);
        }

        @Override
        public String parseValue(String newVal) {
            return newVal;
        }
    }

    public static abstract class InputConfig<T>
    extends ParentedConfig<T> {
        public final InputType inputType;

        public InputConfig(String name, Category category, T defaultValue, InputType inputType) {
            super(name, category, defaultValue);
            this.inputType = inputType;
        }
    }

    public static class EnumConfig
    extends ParentedConfig<Integer> {
        public List<Component> enumList;
        public List<Component> enumTooltip;

        public EnumConfig(String name, Category category, int defaultValue, int length) {
            super((String)name, category, defaultValue);
            name = "config." + (String)name;
            ArrayList<Component> enumList = new ArrayList<Component>();
            ArrayList<Component> enumTooltip = new ArrayList<Component>();
            for (int i = 1; i <= length; ++i) {
                enumList.add((Component)FiguraText.of((String)name + "." + i));
                enumTooltip.add((Component)FiguraText.of((String)name + "." + i + ".tooltip"));
            }
            this.enumList = enumList;
            this.enumTooltip = enumTooltip;
        }

        @Override
        public Integer parseValue(String newVal) {
            return Math.floorMod(Integer.parseInt(newVal), this.enumList.size());
        }
    }

    public static class BoolConfig
    extends ParentedConfig<Boolean> {
        public BoolConfig(String name, Category category, Boolean defaultValue, boolean hidden) {
            super(name, category, defaultValue, hidden);
        }

        public BoolConfig(String name, Category category, Boolean defaultValue) {
            this(name, category, defaultValue, false);
        }

        @Override
        public Boolean parseValue(String newVal) {
            return Boolean.valueOf(newVal);
        }
    }

    public static abstract class ParentedConfig<T>
    extends ConfigType<T> {
        public final Category parent;

        public ParentedConfig(String name, Category category, T value, boolean hidden) {
            super(name, value, hidden);
            this.parent = category;
            category.children.add(this);
            ConfigManager.REGISTRY.add(this);
        }

        public ParentedConfig(String name, Category category, T value) {
            this(name, category, value, false);
        }
    }

    public static class Category
    extends ConfigType<Void> {
        public final List<ConfigType<?>> children = new ArrayList();

        public Category(String name) {
            super(name, null);
            ConfigManager.CATEGORIES_REGISTRY.put(name, this);
        }

        @Override
        public Void parseValue(String newVal) {
            return null;
        }

        @Override
        public void setValue(String newVal) {
        }
    }

    public static interface SerializableConfig {
        public JsonElement serialize();

        public void deserialize(JsonElement var1);
    }
}

