/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.lists.KeybindList;
import org.figuramc.figura.lua.api.keybind.FiguraKeybind;
import org.figuramc.figura.utils.FiguraText;

public class KeybindScreen
extends AbstractPanelScreen {
    private final Screen sourcePanel;
    private KeybindList list;

    public KeybindScreen(AbstractPanelScreen parentScreen) {
        super(parentScreen.parentScreen, (Component)FiguraText.of("gui.panels.title.keybind"));
        this.sourcePanel = parentScreen;
    }

    @Override
    public Class<? extends Screen> getSelectedPanel() {
        return this.sourcePanel.getClass();
    }

    @Override
    protected void init() {
        super.init();
        Avatar owner = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        Button reset = new Button(this.width / 2 - 122, this.height - 24, 120, 20, (Component)FiguraText.of("gui.reset_all"), null, button -> {
            if (owner == null || owner.luaRuntime == null) {
                return;
            }
            for (FiguraKeybind keybind : owner.luaRuntime.keybinds.keyBindings) {
                keybind.resetDefaultKey();
            }
            this.list.updateBindings();
        });
        this.addRenderableWidget((GuiEventListener)reset);
        reset.setActive(false);
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 4, this.height - 24, 120, 20, (Component)FiguraText.of("gui.done"), null, bx -> this.onClose()));
        int listWidth = Math.min(this.width - 8, 420);
        this.list = new KeybindList((this.width - listWidth) / 2, 28, listWidth, this.height - 56, owner, reset);
        this.addRenderableWidget((GuiEventListener)this.list);
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.sourcePanel);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.list.updateKey(InputConstants.Type.MOUSE.getOrCreate(button)) || super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.list.updateKey(keyCode == 256 ? InputConstants.UNKNOWN : InputConstants.getKey((int)keyCode, (int)scanCode)) || super.keyPressed(keyCode, scanCode, modifiers);
    }
}

