/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.widgets.Button;
import org.figuramc.figura.gui.widgets.PianoWidget;
import org.figuramc.figura.gui.widgets.lists.SoundsList;
import org.figuramc.figura.utils.FiguraText;

public class SoundScreen
extends AbstractPanelScreen {
    private final Screen sourcePanel;
    private PianoWidget piano;

    public SoundScreen(AbstractPanelScreen parentScreen) {
        super(parentScreen.parentScreen, (Component)FiguraText.of("gui.panels.title.sound"));
        this.sourcePanel = parentScreen;
    }

    @Override
    public Class<? extends Screen> getSelectedPanel() {
        return this.sourcePanel.getClass();
    }

    @Override
    protected void init() {
        super.init();
        Avatar owner = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        int listWidth = Math.min(this.width - 8, 420);
        int listX = (this.width - listWidth) / 2;
        SoundsList list = new SoundsList(listX, 28, listWidth, this.height - 120, owner);
        this.addRenderableWidget((GuiEventListener)list);
        this.piano = new PianoWidget(listX, this.height - 88, listWidth, 60, list::getSound);
        this.addRenderableWidget((GuiEventListener)this.piano);
        this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 60, this.height - 24, 120, 20, (Component)FiguraText.of("gui.done"), null, bx -> this.onClose()));
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.sourcePanel);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.piano.pressed = button == 0;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.piano.pressed = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

