/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import org.figuramc.figura.utils.ClickableTextHelper;
import org.figuramc.figura.utils.ui.UIHelper;

public class BackendMotdWidget
extends AbstractScrollWidget {
    private final Font font;
    private final ClickableTextHelper textHelper;
    private int maxWidth;
    private boolean mouseDown = false;

    public BackendMotdWidget(int i, int j, int k, int l, Component text, Font font) {
        super(i, j, k, l, text);
        this.font = font;
        this.textHelper = new ClickableTextHelper();
        this.maxWidth = this.getWidth() - this.totalInnerPadding();
    }

    public void setMessage(Component message) {
        super.setMessage(message);
        this.textHelper.setMessage(message);
    }

    public void setWidth(int value) {
        super.setWidth(value);
        int prevWidth = this.maxWidth;
        this.maxWidth = this.getWidth() - this.totalInnerPadding();
        if (this.maxWidth != prevWidth) {
            this.textHelper.markDirty();
        }
    }

    protected int getInnerHeight() {
        Objects.requireNonNull(this.font);
        int n = this.textHelper.lineCount();
        Objects.requireNonNull(this.font);
        return n * 9;
    }

    protected double scrollRate() {
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        return 9.0;
    }

    protected void renderBorder(GuiGraphics graphics, int x, int y, int width, int height) {
        UIHelper.blitSliced(graphics, this.getX() - this.innerPadding(), this.getY() - this.innerPadding(), this.getWidth() + this.totalInnerPadding(), this.getHeight() + this.totalInnerPadding(), UIHelper.OUTLINE_FILL);
    }

    protected void renderBackground(GuiGraphics graphics) {
        UIHelper.blitSliced(graphics, this.getX() - this.innerPadding(), this.getY() - this.innerPadding(), this.getWidth() + this.totalInnerPadding(), this.getHeight() + this.totalInnerPadding(), UIHelper.OUTLINE_FILL);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            if (!this.scrollbarVisible()) {
                this.renderBackground(graphics);
                this.renderContents(graphics, mouseX, mouseY, delta);
            } else {
                super.renderWidget(graphics, mouseX, mouseY, delta);
            }
        }
    }

    protected void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int xx = this.getX() + this.innerPadding();
        int yy = this.getY() + this.innerPadding();
        int scroll = (int)this.scrollAmount();
        this.textHelper.update(this.font, this.maxWidth);
        this.textHelper.visit((text, style, x, y, textWidth, textHeight) -> graphics.drawString(this.font, (Component)Component.literal((String)text).setStyle(style), xx + x, yy + y, -1));
        if (this.withinContentAreaPoint(mouseX, mouseY)) {
            Component tooltip = this.textHelper.getHoverTooltip(xx, yy, mouseX, mouseY + scroll);
            if (tooltip != null) {
                UIHelper.setTooltip(tooltip);
            }
            if (this.mouseDown) {
                String link = this.textHelper.getClickLink(xx, yy, mouseX, mouseY + scroll);
                if (link != null) {
                    UIHelper.openURL(link).run();
                }
                this.mouseDown = false;
            }
        }
    }

    public void playDownSound(SoundManager soundManager) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.mouseDown = super.mouseClicked(mouseX, mouseY, button);
        return this.mouseDown;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        builder.add(NarratedElementType.TITLE, this.getMessage());
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean shouldRender() {
        return this.getScrollBarHeight() > 0 && this.height >= 48;
    }
}

