/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class ContainerButton
extends SwitchButton {
    private final AbstractList parent;

    public ContainerButton(AbstractList parent, int x, int y, int width, int height, Component text, Component tooltip, Button.OnPress pressAction) {
        super(x, y, width, height, text, tooltip, pressAction);
        this.parent = parent;
    }

    @Override
    protected void renderText(GuiGraphics gui, float delta) {
        Font font = Minecraft.getInstance().font;
        int color = this.getTextColor();
        Component arrow = this.toggled ? UIHelper.DOWN_ARROW : UIHelper.UP_ARROW;
        int arrowWidth = font.width((FormattedText)arrow);
        Component message = TextUtils.trimToWidthEllipsis(font, this.getMessage(), this.getWidth() - arrowWidth - 6, (Component)TextUtils.ELLIPSIS.copy().withStyle(this.getMessage().getStyle()));
        int n = this.getX() + arrowWidth + 6;
        float f = (float)this.getY() + (float)this.getHeight() / 2.0f;
        Objects.requireNonNull(font);
        gui.drawString(font, message, n, (int)(f - 9.0f / 2.0f), color);
        int n2 = this.getX() + 3;
        float f2 = (float)this.getY() + (float)this.getHeight() / 2.0f;
        Objects.requireNonNull(font);
        gui.drawString(font, arrow, n2, (int)(f2 - 9.0f / 2.0f), color);
        if (message != this.getMessage()) {
            this.setTooltip(this.getMessage());
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.parent.isInsideScissors(mouseX, mouseY) && super.isMouseOver(mouseX, mouseY);
    }

    @Override
    protected int getTextColor() {
        return !this.isToggled() ? ChatFormatting.DARK_GRAY.getColor().intValue() : super.getTextColor();
    }
}

