/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.lists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.gui.screens.PermissionsScreen;
import org.figuramc.figura.gui.widgets.SearchBar;
import org.figuramc.figura.gui.widgets.SwitchButton;
import org.figuramc.figura.gui.widgets.lists.AbstractList;
import org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.CategoryPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.PlayerPermPackElement;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class PlayerList
extends AbstractList {
    private final HashMap<UUID, PlayerPermPackElement> players = new HashMap();
    private final HashSet<UUID> missingPlayers = new HashSet();
    private final ArrayList<AbstractPermPackElement> permissionsList = new ArrayList();
    public final PermissionsScreen parent;
    private final SearchBar searchBar;
    private final SwitchButton showFigura;
    private final SwitchButton showDisconnected;
    private static boolean showFiguraBl;
    private static boolean showDisconnectedBl;
    private final int entryWidth;
    private int totalHeight = 0;
    private AbstractPermPackElement maxCategory;
    public AbstractPermPackElement selectedEntry;
    private String filter = "";

    public PlayerList(int x, int y, int width, int height, PermissionsScreen parent) {
        super(x, y, width, height);
        this.updateScissors(1, 24, -2, -25);
        this.parent = parent;
        this.entryWidth = Math.min(width - this.scrollBar.getWidth() - 12, 174);
        this.scrollBar.setY(y + 28);
        this.scrollBar.setHeight(height - 32);
        this.searchBar = new SearchBar(x + 4, y + 4, width - 56, 20, s -> {
            if (!this.filter.equals(s)) {
                this.scrollBar.setScrollProgress(0.0);
            }
            this.filter = s;
        });
        this.children.add(this.searchBar);
        this.showFigura = new SwitchButton(x + width - 48, y + 4, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/show_figura.png"), 60, 40, (Component)FiguraText.of("gui.permissions.figura_only.tooltip"), button -> {
            showFiguraBl = ((SwitchButton)button).isToggled();
        });
        this.children.add(this.showFigura);
        this.showFigura.setToggled(showFiguraBl);
        this.showDisconnected = new SwitchButton(x + width - 24, y + 4, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/show_disconnected.png"), 60, 40, (Component)FiguraText.of("gui.permissions.disconnected.tooltip"), button -> {
            showDisconnectedBl = ((SwitchButton)button).isToggled();
        });
        this.children.add(this.showDisconnected);
        this.showDisconnected.setToggled(showDisconnectedBl);
        this.loadGroups();
        this.loadPlayers();
        this.selectLocalPlayer();
    }

    @Override
    public void tick() {
        this.loadPlayers();
        super.tick();
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.totalHeight = 0;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (!pack.isVisible()) continue;
            this.totalHeight += pack.getHeight() + 8;
        }
        boolean hasScrollbar = this.totalHeight > height - 32;
        this.scrollBar.setVisible(hasScrollbar);
        this.scrollBar.setScrollRatio(this.permissionsList.isEmpty() ? 0.0 : (double)((float)this.totalHeight / (float)this.permissionsList.size()), this.totalHeight - (height - 32));
        this.scissorsWidth = hasScrollbar ? -this.scrollBar.getWidth() - 5 : -2;
        this.enableScissors(gui);
        int xOffset = (width - this.entryWidth - (this.scrollBar.isVisible() ? 13 : 0)) / 2;
        int playerY = this.scrollBar.isVisible() ? (int)(-Mth.lerp((double)this.scrollBar.getScrollProgress(), (double)-32.0, (double)(this.totalHeight - height))) : 32;
        int minY = y + this.scissorsY;
        int maxY = minY + height + this.scissorsHeight;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (!pack.isVisible()) continue;
            pack.setX(x + xOffset);
            pack.setY(y + playerY);
            if (pack.getY() + pack.getHeight() > minY && pack.getY() < maxY) {
                pack.render(gui, mouseX, mouseY, delta);
            }
            playerY += pack.getHeight() + 8;
        }
        gui.disableScissor();
        super.render(gui, mouseX, mouseY, delta);
    }

    @Override
    public List<? extends GuiEventListener> contents() {
        return this.permissionsList;
    }

    private void loadGroups() {
        for (PermissionPack permissionPack : PermissionManager.CATEGORIES.values()) {
            CategoryPermPackElement group = new CategoryPermPackElement(this.entryWidth, permissionPack, this);
            this.permissionsList.add(group);
            this.children.add(group);
            this.maxCategory = group;
        }
    }

    private void loadPlayers() {
        PlayerPermPackElement player;
        this.missingPlayers.clear();
        this.missingPlayers.addAll(this.players.keySet());
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        ArrayList playerList = connection == null ? List.of() : new ArrayList(connection.getOnlinePlayerIds());
        for (UUID uuid2 : playerList) {
            PlayerInfo player2 = connection.getPlayerInfo(uuid2);
            if (player2 == null) continue;
            String name = player2.getProfile().getName();
            ResourceLocation skin = player2.getSkin().texture();
            Avatar avatar = AvatarManager.getAvatarForPlayer(uuid2);
            if (!name.toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !uuid2.toString().contains(this.filter.toLowerCase(Locale.US)) || this.showFigura.isToggled() && !FiguraMod.isLocal(uuid2) && (avatar == null || avatar.nbt == null)) continue;
            this.missingPlayers.remove(uuid2);
            PlayerPermPackElement element = this.players.computeIfAbsent(uuid2, uuid1 -> {
                PlayerPermPackElement entry = new PlayerPermPackElement(this.entryWidth, name, PermissionManager.get(uuid1), skin, (UUID)uuid1, this);
                this.permissionsList.add(entry);
                this.children.add(entry);
                return entry;
            });
            element.disconnected = false;
        }
        if (this.filter.isEmpty() && this.showDisconnected.isToggled()) {
            for (Avatar avatar : AvatarManager.getLoadedAvatars()) {
                UUID id = avatar.owner;
                if (playerList.contains(id)) continue;
                this.missingPlayers.remove(id);
                PlayerPermPackElement element = this.players.computeIfAbsent(id, uuid -> {
                    PlayerPermPackElement entry = new PlayerPermPackElement(this.entryWidth, avatar.entityName, PermissionManager.get(uuid), null, (UUID)uuid, this);
                    this.permissionsList.add(entry);
                    this.children.add(entry);
                    return entry;
                });
                element.disconnected = true;
            }
        }
        for (UUID missingID : this.missingPlayers) {
            PlayerPermPackElement entry = this.players.remove(missingID);
            this.permissionsList.remove(entry);
            this.children.remove(entry);
        }
        this.sortList();
        AbstractPermPackElement abstractPermPackElement = this.selectedEntry;
        if (abstractPermPackElement instanceof PlayerPermPackElement && this.missingPlayers.contains((player = (PlayerPermPackElement)abstractPermPackElement).getOwner())) {
            this.selectLocalPlayer();
        }
    }

    private void sortList() {
        this.permissionsList.sort(AbstractPermPackElement::compareTo);
        this.children.sort((element1, element2) -> {
            if (element1 instanceof AbstractPermPackElement) {
                AbstractPermPackElement container1 = (AbstractPermPackElement)element1;
                if (element2 instanceof AbstractPermPackElement) {
                    AbstractPermPackElement container2 = (AbstractPermPackElement)element2;
                    return container1.compareTo(container2);
                }
            }
            return 0;
        });
    }

    private void selectLocalPlayer() {
        AbstractPermPackElement local;
        AbstractPermPackElement abstractPermPackElement = local = Minecraft.getInstance().player != null ? this.players.get(Minecraft.getInstance().player.getUUID()) : null;
        if (local != null) {
            local.onPress();
        } else {
            this.maxCategory.onPress();
        }
        this.scrollToSelected();
    }

    public void updateScroll() {
        double pastScroll = (double)(this.totalHeight - this.getHeight()) * this.scrollBar.getScrollProgress();
        this.totalHeight = 0;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (!pack.isVisible()) continue;
            this.totalHeight += pack.getHeight() + 8;
        }
        this.scrollBar.setScrollProgress(pastScroll / (double)(this.totalHeight - this.getHeight()));
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.scrollBar.setY(y + 28);
        this.searchBar.setY(y + 4);
        this.showFigura.setY(y + 4);
        this.showDisconnected.setY(y + 4);
    }

    public int getCategoryAt(double y) {
        int ret = -1;
        for (AbstractPermPackElement element : this.permissionsList) {
            CategoryPermPackElement group;
            if (!(element instanceof CategoryPermPackElement) || !(group = (CategoryPermPackElement)element).isVisible() || !(y >= (double)group.getY())) continue;
            ++ret;
        }
        return Math.max(ret, 0);
    }

    public void scrollToSelected() {
        double y = 0.0;
        this.totalHeight = 0;
        for (AbstractPermPackElement pack : this.permissionsList) {
            if (pack instanceof PlayerPermPackElement && !pack.isVisible()) continue;
            if (pack == this.selectedEntry) {
                y = this.totalHeight;
                continue;
            }
            this.totalHeight += pack.getHeight() + 8;
        }
        this.scrollBar.setScrollProgressNoAnim(y / (double)this.totalHeight);
    }
}

