/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets.permissions;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.Label;
import org.figuramc.figura.gui.widgets.lists.PlayerList;
import org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import org.figuramc.figura.gui.widgets.permissions.PlayerStatusWidget;
import org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class PlayerPermPackElement
extends AbstractPermPackElement {
    public static final ResourceLocation UNKNOWN = new FiguraIdentifier("textures/gui/unknown_portrait.png");
    private static final ResourceLocation BACKGROUND = new FiguraIdentifier("textures/gui/player_permissions.png");
    private static final Component DC_TEXT = FiguraText.of("gui.permissions.disconnected").withStyle(ChatFormatting.RED);
    private final String name;
    private final ResourceLocation skin;
    private final UUID owner;
    private final ContextMenu context;
    private final Label nameLabel;
    private final PlayerStatusWidget status;
    public boolean disconnected = false;
    public boolean dragged = false;
    public int anchorX;
    public int anchorY;
    public int initialY;
    public int index;

    public PlayerPermPackElement(int width, String name, PermissionPack pack, ResourceLocation skin, UUID owner, PlayerList parent) {
        super(width, 40, pack, parent);
        this.name = name;
        this.skin = skin;
        this.owner = owner;
        this.context = new ContextMenu((GuiEventListener)this);
        this.nameLabel = new Label((Object)name, 0, 0, 0);
        this.status = new PlayerStatusWidget(0, 0, 70, owner);
        this.generateContext();
    }

    private void generateContext() {
        this.context.addAction((Component)FiguraText.of("gui.context.copy_name"), null, button -> {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getName());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
        this.context.addAction((Component)FiguraText.of("gui.context.copy_uuid"), null, button -> {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getOwner().toString());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
        this.context.addAction((Component)FiguraText.of("gui.context.reload"), null, button -> {
            AvatarManager.reloadAvatar(this.owner);
            FiguraToast.sendToast(FiguraText.of("toast.reload"));
        });
        ContextMenu permissionsContext = new ContextMenu();
        for (Permissions.Category category : Permissions.Category.values()) {
            PermissionPack.CategoryPermissionPack categoryPack = PermissionManager.CATEGORIES.get((Object)category);
            permissionsContext.addAction((Component)categoryPack.getCategoryName(), null, button -> {
                this.pack.setCategory(categoryPack);
                if (this.parent.selectedEntry == this) {
                    this.parent.parent.updatePermissions(this.pack);
                }
            });
        }
        this.context.addTab((Component)FiguraText.of("gui.context.set_permissions"), null, permissionsContext);
    }

    public void renderDragged(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int oX = this.getX();
        int oY = this.getY();
        this.setX(mouseX - (this.anchorX - oX));
        this.setY(mouseY - (this.anchorY - oY) + (this.initialY - oY));
        super.render(gui, mouseX, mouseY, delta);
        this.setX(oX);
        this.setY(oY);
    }

    @Override
    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (this.dragged) {
            UIHelper.fillRounded(gui, this.getX() - 1, this.getY() - 1, this.getWidth() + 2, this.getHeight() + 2, 0x40FFFFFF);
        } else {
            PoseStack pose = gui.pose();
            int width = this.getWidth();
            int height = this.getHeight();
            pose.pushPose();
            float tx = (float)this.getX() + (float)width / 2.0f;
            float ty = (float)this.getY() + (float)height / 2.0f;
            pose.translate(tx, ty, 100.0f);
            pose.scale(this.scale, this.scale, 1.0f);
            this.animate(delta, UIHelper.getContext() == this.context && this.context.isVisible() || this.isMouseOver(mouseX, mouseY) || this.isFocused());
            int x = -width / 2;
            int y = -height / 2;
            mouseX = (int)(((float)mouseX - tx) / this.scale);
            mouseY = (int)(((float)mouseY - ty) / this.scale);
            if (this.parent.selectedEntry == this) {
                ArrayList<PermissionPack.CategoryPermissionPack> list = new ArrayList<PermissionPack.CategoryPermissionPack>(PermissionManager.CATEGORIES.values());
                int color = (this.dragged ? (PermissionPack)list.get(Math.min(this.index, list.size() - 1)) : this.pack).getColor();
                UIHelper.fillRounded(gui, x - 1, y - 1, width + 2, height + 2, color + -16777216);
            }
            UIHelper.renderHalfTexture(gui, x, y, width, height, 174, BACKGROUND);
            MutableComponent name = null;
            boolean head = false;
            Avatar avatar = AvatarManager.getAvatarForPlayer(this.owner);
            if (avatar != null) {
                LivingEntity entity;
                Entity e;
                NameplateCustomization custom;
                NameplateCustomization nameplateCustomization = custom = avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.LIST;
                if (custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1) {
                    name = custom.getJson().copy();
                }
                boolean upsideDown = (e = EntityUtils.getEntityByUUID(this.owner)) instanceof LivingEntity && LivingEntityRenderer.isEntityUpsideDown((LivingEntity)(entity = (LivingEntity)e));
                head = avatar.renderPortrait(gui, x + 4, y + 4, Math.round(32.0f * this.scale), 64.0f, upsideDown);
            }
            if (!head) {
                if (this.skin != null) {
                    UIHelper.enableBlend();
                    gui.blit(this.skin, x + 4, y + 4, 32, 32, 8.0f, 8.0f, 8, 8, 64, 64);
                    RenderSystem.enableBlend();
                    gui.blit(this.skin, x + 4, y + 4, 32, 32, 40.0f, 8.0f, 8, 8, 64, 64);
                    RenderSystem.disableBlend();
                } else {
                    UIHelper.blit(gui, x + 4, y + 4, 32, 32, UNKNOWN);
                }
            }
            Font font = Minecraft.getInstance().font;
            MutableComponent ogName = Component.literal((String)this.name);
            if (name == null) {
                name = ogName;
            }
            name = TextUtils.replaceInText((FormattedText)name, "\\$\\{name\\}", ogName);
            name = TextUtils.splitText((FormattedText)name, "\n").get(0);
            name = Component.empty().append((Component)name.copy().withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)(this.name + "\n" + String.valueOf(this.owner)))))));
            name = Badges.appendBadges((Component)name, this.owner, false);
            Component badges = Badges.fetchBadges(this.owner);
            if (!badges.getString().isEmpty()) {
                badges = Component.literal((String)" ").append(badges);
            }
            this.nameLabel.setText((Component)TextUtils.trimToWidthEllipsis(font, (Component)name, width - 44 - font.width((FormattedText)badges), TextUtils.ELLIPSIS).copy().append(badges));
            this.nameLabel.setX(x + 40);
            this.nameLabel.setY(y + 4);
            this.nameLabel.render(gui, mouseX, mouseY, delta);
            if (avatar != null && avatar.nbt != null) {
                this.status.tick();
                this.status.setX(x + 40);
                Objects.requireNonNull(font);
                this.status.setY(y + 6 + 9);
                this.status.render(gui, mouseX, mouseY, delta);
            }
            Objects.requireNonNull(font);
            int textY = y + height - 9 - 4;
            gui.drawString(font, (Component)this.pack.getCategoryName().append(this.pack.hasChanges() ? "*" : ""), x + 40, textY, 0xFFFFFF);
            if (this.disconnected) {
                gui.drawString(font, DC_TEXT, x + width - font.width((FormattedText)DC_TEXT) - 4, textY, 0xFFFFFF);
            }
            pose.popPose();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 1) {
            this.context.setX((int)mouseX);
            this.context.setY((int)mouseY);
            this.context.setVisible(true);
            UIHelper.setContext(this.context);
            return true;
        }
        if (UIHelper.getContext() == this.context) {
            this.context.setVisible(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return !this.dragged && super.isMouseOver(mouseX, mouseY);
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.pack.isVisible();
    }
}

