/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.LivingEntityAPI;
import org.figuramc.figura.lua.api.entity.PlayerAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMetamethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.EntityAccessor;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="EntityAPI", value="entity")
public class EntityAPI<T extends Entity> {
    @NotNull
    protected final UUID entityUUID;
    @NotNull
    protected T entity;
    private String cacheType;

    public EntityAPI(T entity) {
        this.entity = entity;
        this.entityUUID = entity.getUUID();
    }

    public static EntityAPI<?> wrap(Entity e) {
        if (e == null) {
            return null;
        }
        if (e instanceof Player) {
            Player p = (Player)e;
            return new PlayerAPI(p);
        }
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            return new LivingEntityAPI<LivingEntity>(le);
        }
        return new EntityAPI<Entity>(e);
    }

    protected final boolean checkEntity() {
        boolean thingy = true;
        if (this.entity.isRemoved() || this.getLevel() != Minecraft.getInstance().level) {
            Entity newEntityInstance = EntityUtils.getEntityByUUID(this.entityUUID);
            boolean bl = thingy = newEntityInstance != null;
            if (thingy) {
                this.entity = newEntityInstance;
            }
        }
        return thingy;
    }

    protected Level getLevel() {
        return ((EntityAccessor)this.entity).getLevel();
    }

    @NotNull
    public T getEntity() {
        return this.entity;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_loaded")
    public boolean isLoaded() {
        return this.checkEntity();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="entity.get_pos")
    public FiguraVec3 getPos(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return FiguraVec3.fromVec3(this.entity.getPosition(delta.floatValue()));
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"delta"})}, value="entity.get_rot")
    public FiguraVec2 getRot(Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return FiguraVec2.of(Mth.lerp((float)delta.floatValue(), (float)((Entity)this.entity).xRotO, (float)this.entity.getXRot()), Mth.lerp((float)delta.floatValue(), (float)((Entity)this.entity).yRotO, (float)this.entity.getYRot()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_uuid")
    public String getUUID() {
        return this.entityUUID.toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_type")
    public String getType() {
        this.checkEntity();
        return this.cacheType != null ? this.cacheType : (this.cacheType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.entity.getType()).toString());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_velocity")
    public FiguraVec3 getVelocity() {
        this.checkEntity();
        return FiguraVec3.of(this.entity.getX() - ((Entity)this.entity).xOld, this.entity.getY() - ((Entity)this.entity).yOld, this.entity.getZ() - ((Entity)this.entity).zOld);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_look_dir")
    public FiguraVec3 getLookDir() {
        this.checkEntity();
        return FiguraVec3.fromVec3(this.entity.getLookAngle());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_frozen_ticks")
    public int getFrozenTicks() {
        this.checkEntity();
        return this.entity.getTicksFrozen();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_max_air")
    public int getMaxAir() {
        this.checkEntity();
        return this.entity.getMaxAirSupply();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_dimension_name")
    public String getDimensionName() {
        this.checkEntity();
        return this.getLevel().dimension().location().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_pose")
    public String getPose() {
        this.checkEntity();
        return this.entity.getPose().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_vehicle")
    public EntityAPI<?> getVehicle() {
        this.checkEntity();
        return EntityAPI.wrap(this.entity.getVehicle());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_on_ground")
    public boolean isOnGround() {
        this.checkEntity();
        return this.entity.onGround();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_eye_height")
    public float getEyeHeight() {
        this.checkEntity();
        return this.entity.getEyeHeight(this.entity.getPose());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_bounding_box")
    public FiguraVec3 getBoundingBox() {
        this.checkEntity();
        EntityDimensions dim = this.entity.getDimensions(this.entity.getPose());
        return FiguraVec3.of(dim.width(), dim.height(), dim.width());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_name")
    public String getName() {
        this.checkEntity();
        return this.entity.getName().getString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_wet")
    public boolean isWet() {
        this.checkEntity();
        return this.entity.isInWaterRainOrBubble();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_water")
    public boolean isInWater() {
        this.checkEntity();
        return this.entity.isInWater();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_underwater")
    public boolean isUnderwater() {
        this.checkEntity();
        return this.entity.isUnderWater();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_lava")
    public boolean isInLava() {
        this.checkEntity();
        return this.entity.isInLava();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_in_rain")
    public boolean isInRain() {
        this.checkEntity();
        BlockPos blockPos = this.entity.blockPosition();
        return this.getLevel().isRainingAt(blockPos) || this.getLevel().isRainingAt(new BlockPos(blockPos.getX(), (int)this.entity.getBoundingBox().maxY, (int)this.entity.getZ()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_avatar")
    public boolean hasAvatar() {
        this.checkEntity();
        return AvatarManager.getAvatar(this.entity) != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_sprinting")
    public boolean isSprinting() {
        this.checkEntity();
        return this.entity.isSprinting();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_eye_y")
    public double getEyeY() {
        this.checkEntity();
        return this.entity.getEyeY();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_glowing")
    public boolean isGlowing() {
        this.checkEntity();
        return this.entity.isCurrentlyGlowing();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_invisible")
    public boolean isInvisible() {
        this.checkEntity();
        return this.entity.isInvisible();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_silent")
    public boolean isSilent() {
        this.checkEntity();
        return this.entity.isSilent();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_sneaking")
    public boolean isSneaking() {
        this.checkEntity();
        return this.entity.isDiscrete();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_crouching")
    public boolean isCrouching() {
        this.checkEntity();
        return this.entity.isCrouching();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"ignoreY"})}, value="entity.is_moving")
    public boolean isMoving(boolean ignoreY) {
        this.checkEntity();
        return this.entity.getX() != ((Entity)this.entity).xOld || !ignoreY && this.entity.getY() != ((Entity)this.entity).yOld || this.entity.getZ() != ((Entity)this.entity).zOld;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_falling")
    public boolean isFalling() {
        this.checkEntity();
        return !this.entity.onGround() && this.entity.getY() < ((Entity)this.entity).yOld;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={int.class}, argumentNames={"index"})}, value="entity.get_item")
    public ItemStackAPI getItem(int index) {
        this.checkEntity();
        if (--index < 0) {
            return null;
        }
        int i = 0;
        if (this.entity instanceof LivingEntity) {
            for (ItemStack item : ((LivingEntity)this.entity).getAllSlots()) {
                if (i == index) {
                    return ItemStackAPI.verify(item);
                }
                ++i;
            }
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_nbt")
    public LuaTable getNbt() {
        this.checkEntity();
        CompoundTag tag = new CompoundTag();
        this.entity.saveWithoutId(tag);
        return (LuaTable)NbtToLua.convert((Tag)tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_on_fire")
    public boolean isOnFire() {
        this.checkEntity();
        return this.entity.displayFireAnimation();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_alive")
    public boolean isAlive() {
        this.checkEntity();
        return this.entity.isAlive();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_permission_level")
    public int getPermissionLevel() {
        this.checkEntity();
        return ((EntityAccessor)this.entity).getPermissionLevel();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_passengers")
    public List<EntityAPI<?>> getPassengers() {
        this.checkEntity();
        ArrayList list = new ArrayList();
        for (Entity passenger : this.entity.getPassengers()) {
            list.add(EntityAPI.wrap(passenger));
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_controlling_passenger")
    public EntityAPI<?> getControllingPassenger() {
        this.checkEntity();
        return EntityAPI.wrap((Entity)this.entity.getControllingPassenger());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.get_controlled_vehicle")
    public EntityAPI<?> getControlledVehicle() {
        this.checkEntity();
        return EntityAPI.wrap(this.entity.getControlledVehicle());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_container")
    public boolean hasContainer() {
        this.checkEntity();
        return this.entity instanceof ContainerEntity;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.has_inventory")
    public boolean hasInventory() {
        this.checkEntity();
        return this.entity instanceof HasCustomInventoryScreen;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"ignoreLiquids"}), @LuaMethodOverload(argumentTypes={Boolean.class, Double.class}, argumentNames={"ignoreLiquids", "distance"})}, value="entity.get_targeted_block")
    public Object[] getTargetedBlock(boolean ignoreLiquids, Double distance) {
        this.checkEntity();
        if (distance == null) {
            distance = 20.0;
        }
        distance = Math.max(Math.min(distance, 20.0), -20.0);
        HitResult result = this.entity.pick(distance.doubleValue(), 1.0f, !ignoreLiquids);
        return LuaUtils.parseBlockHitResult(result);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"distance"})}, value="entity.get_targeted_entity")
    public Object[] getTargetedEntity(Double distance) {
        AABB aABB;
        this.checkEntity();
        if (distance == null) {
            distance = 20.0;
        }
        distance = Math.max(Math.min(distance, 20.0), 0.0);
        Vec3 vec3 = this.entity.getEyePosition(1.0f);
        HitResult result = this.entity.pick(distance.doubleValue(), 1.0f, false);
        distance = result.getLocation().distanceToSqr(vec3);
        Vec3 vec32 = this.entity.getViewVector(1.0f);
        Vec3 vec33 = vec3.add(vec32.x * distance, vec32.y * distance, vec32.z * distance);
        EntityHitResult entityHit = ProjectileUtil.getEntityHitResult(this.entity, (Vec3)vec3, (Vec3)vec33, (AABB)(aABB = this.entity.getBoundingBox().expandTowards(vec32.scale(distance.doubleValue())).inflate(1.0)), e -> e != this.entity, (double)distance);
        if (entityHit != null) {
            return new Object[]{EntityAPI.wrap(entityHit.getEntity()), FiguraVec3.fromVec3(entityHit.getLocation())};
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, Double.class}, argumentNames={"type", "radius"}), @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"type"}), @LuaMethodOverload}, value="entity.get_nearest_entity")
    public EntityAPI<?> getNearestEntity(String type, Double radius) {
        EntityType entityType;
        this.checkEntity();
        radius = radius != null ? radius : 20.0;
        if (type != null) {
            ResourceLocation id = ResourceLocation.tryParse((String)type);
            if (id == null) {
                throw new LuaError("Invalid entity type: " + type);
            }
            entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
        } else {
            entityType = null;
        }
        FiguraVec3 pos = this.getPos(Float.valueOf(1.0f));
        AABB aabb = new AABB(((FiguraVec3)pos.offseted(-radius.doubleValue())).asVec3(), ((FiguraVec3)pos.offseted(radius)).asVec3());
        return this.getLevel().getEntities(this.entity, aabb).stream().filter(e -> entityType == null || e.getType() == entityType).min(Comparator.comparingDouble(e -> e.distanceToSqr(pos.x(), pos.y(), pos.z()))).map(EntityAPI::wrap).orElse(null);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"key"})}, value="entity.get_variable")
    public LuaValue getVariable(String key) {
        this.checkEntity();
        Avatar a = AvatarManager.getAvatar(this.entity);
        LuaTable table = a == null || a.luaRuntime == null ? new LuaTable() : a.luaRuntime.avatar_meta.storedStuff;
        table = new ReadOnlyLuaTable((LuaValue)table);
        return key == null ? table : table.get(key);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_living")
    public boolean isLiving() {
        return this instanceof LivingEntityAPI;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity.is_player")
    public boolean isPlayer() {
        return this instanceof PlayerAPI;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={boolean.class, EntityAPI.class, EntityAPI.class})})
    public boolean __eq(EntityAPI<?> rhs) {
        return this.entity.equals(rhs.entity);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={String.class, EntityAPI.class})})
    public String __tostring() {
        return this.toString();
    }

    public String toString() {
        this.checkEntity();
        return (String)(this.entity.hasCustomName() ? this.entity.getCustomName().getString() + " (" + this.getType() + ")" : this.getType()) + " (Entity)";
    }
}

