/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.entity;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.PlayerTeam;
import org.figuramc.figura.lua.LuaNotNil;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.entity.LivingEntityAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.utils.EntityUtils;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;

@LuaWhitelist
@LuaTypeDoc(name="PlayerAPI", value="player")
public class PlayerAPI
extends LivingEntityAPI<Player> {
    private PlayerInfo playerInfo;

    public PlayerAPI(Player entity) {
        super(entity);
    }

    private boolean checkPlayerInfo() {
        if (this.playerInfo != null) {
            return true;
        }
        PlayerInfo info = EntityUtils.getPlayerInfo(((Player)this.entity).getUUID());
        if (info == null) {
            return false;
        }
        this.playerInfo = info;
        return true;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_food")
    public int getFood() {
        this.checkEntity();
        return ((Player)this.entity).getFoodData().getFoodLevel();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_saturation")
    public float getSaturation() {
        this.checkEntity();
        return ((Player)this.entity).getFoodData().getSaturationLevel();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_exhaustion")
    public float getExhaustion() {
        this.checkEntity();
        return ((Player)this.entity).getFoodData().getExhaustionLevel();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_experience_progress")
    public float getExperienceProgress() {
        this.checkEntity();
        return ((Player)this.entity).experienceProgress;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_experience_level")
    public int getExperienceLevel() {
        this.checkEntity();
        return ((Player)this.entity).experienceLevel;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_model_type")
    public String getModelType() {
        this.checkEntity();
        return (this.checkPlayerInfo() ? this.playerInfo.getSkin().model().id().toUpperCase() : DefaultPlayerSkin.get((UUID)((Player)this.entity).getUUID()).model().id()).toUpperCase(Locale.US);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_gamemode")
    public String getGamemode() {
        this.checkEntity();
        if (!this.checkPlayerInfo()) {
            return null;
        }
        GameType gamemode = this.playerInfo.getGameMode();
        return gamemode == null ? null : gamemode.getName().toUpperCase(Locale.US);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.has_cape")
    public boolean hasCape() {
        this.checkEntity();
        return this.checkPlayerInfo() && this.playerInfo.getSkin().capeTexture() != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.has_skin")
    public boolean hasSkin() {
        this.checkEntity();
        return this.checkPlayerInfo() && this.playerInfo.getSkin().texture() != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"part"})}, value="player.is_skin_layer_visible")
    public boolean isSkinLayerVisible(@LuaNotNil String part) {
        this.checkEntity();
        try {
            if (((String)part).equalsIgnoreCase("left_pants") || ((String)part).equalsIgnoreCase("right_pants")) {
                part = (String)part + "_leg";
            }
            return ((Player)this.entity).isModelPartShown(PlayerModelPart.valueOf((String)((String)part).toUpperCase(Locale.US)));
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid player model part: " + (String)part);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.is_fishing")
    public boolean isFishing() {
        this.checkEntity();
        return ((Player)this.entity).fishing != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_charged_attack_delay")
    public float getChargedAttackDelay() {
        this.checkEntity();
        return ((Player)this.entity).getCurrentItemAttackStrengthDelay();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"right"})}, value="player.get_shoulder_entity")
    public LuaTable getShoulderEntity(boolean right) {
        this.checkEntity();
        return new ReadOnlyLuaTable(NbtToLua.convert((Tag)(right ? ((Player)this.entity).getShoulderEntityRight() : ((Player)this.entity).getShoulderEntityLeft())));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="player.get_team_info")
    public Map<String, Object> getTeamInfo() {
        this.checkEntity();
        if (!this.checkPlayerInfo()) {
            return null;
        }
        PlayerTeam team = this.playerInfo.getTeam();
        if (team == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", team.getName());
        map.put("display_name", team.getDisplayName().getString());
        map.put("color", team.getColor().getName());
        map.put("prefix", team.getPlayerPrefix().getString());
        map.put("suffix", team.getPlayerSuffix().getString());
        map.put("friendly_fire", team.isAllowFriendlyFire());
        map.put("see_friendly_invisibles", team.canSeeFriendlyInvisibles());
        map.put("nametag_visibility", team.getNameTagVisibility().name);
        map.put("death_message_visibility", team.getDeathMessageVisibility().name);
        map.put("collision_rule", team.getCollisionRule().name);
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={ItemStackAPI.class, Float.class}, argumentNames={"stack", "delta"})}, value="player.get_cooldown_percent")
    public float getCooldownPercent(@LuaNotNil ItemStackAPI stack, Float delta) {
        this.checkEntity();
        if (delta == null) {
            delta = Float.valueOf(0.0f);
        }
        return ((Player)this.entity).getCooldowns().getCooldownPercent(stack.itemStack.getItem(), delta.floatValue());
    }

    @Override
    public String toString() {
        this.checkEntity();
        return ((Player)this.entity).getName().getString() + " (Player)";
    }
}

