/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.mixin.render;

import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.utils.RenderUtils;
import org.figuramc.figura.utils.ui.UIHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    @Shadow
    private float xRot;
    @Shadow
    private float yRot;
    @Unique
    private Avatar avatar;

    @Shadow
    protected abstract void setRotation(float var1, float var2);

    @Shadow
    protected abstract void move(float var1, float var2, float var3);

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="HEAD")})
    private void setupAvatarVar(BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        this.avatar = AvatarManager.getAvatar(focusedEntity);
    }

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setRotation(FF)V", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/Camera;setRotation(FFF)V", shift=At.Shift.AFTER)}, require=1)
    private void setupRot(BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        FiguraVec3 offset;
        if (!RenderUtils.vanillaModelAndScript(this.avatar)) {
            this.avatar = null;
            return;
        }
        float x = this.xRot;
        float y = this.yRot;
        FiguraVec3 rot = this.avatar.luaRuntime.renderer.cameraRot;
        if (rot != null && rot.notNaN()) {
            x = (float)rot.x;
            y = (float)rot.y;
        }
        if ((offset = this.avatar.luaRuntime.renderer.cameraOffsetRot) != null && offset.notNaN()) {
            x += (float)offset.x;
            y += (float)offset.y;
        }
        this.setRotation(y, x);
    }

    @ModifyArg(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V"), index=0)
    private double setupPivotX(double originalX) {
        if (RenderUtils.vanillaModelAndScript(this.avatar)) {
            FiguraVec3 offset;
            double x = originalX;
            FiguraVec3 piv = this.avatar.luaRuntime.renderer.cameraPivot;
            if (piv != null && piv.notNaN()) {
                x = piv.x;
            }
            if ((offset = this.avatar.luaRuntime.renderer.cameraOffsetPivot) != null && offset.notNaN()) {
                x += offset.x;
            }
            return x;
        }
        return originalX;
    }

    @ModifyArg(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V"), index=1)
    private double setupPivotY(double originalY) {
        if (RenderUtils.vanillaModelAndScript(this.avatar)) {
            FiguraVec3 offset;
            double y = originalY;
            FiguraVec3 piv = this.avatar.luaRuntime.renderer.cameraPivot;
            if (piv != null && piv.notNaN()) {
                y = piv.y;
            }
            if ((offset = this.avatar.luaRuntime.renderer.cameraOffsetPivot) != null && offset.notNaN()) {
                y += offset.y;
            }
            return y;
        }
        return originalY;
    }

    @ModifyArg(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setPosition(DDD)V"), index=2)
    private double setupPivotZ(double originalZ) {
        if (RenderUtils.vanillaModelAndScript(this.avatar)) {
            FiguraVec3 offset;
            double z = originalZ;
            FiguraVec3 piv = this.avatar.luaRuntime.renderer.cameraPivot;
            if (piv != null && piv.notNaN()) {
                z = piv.z;
            }
            if ((offset = this.avatar.luaRuntime.renderer.cameraOffsetPivot) != null && offset.notNaN()) {
                z += offset.z;
            }
            return z;
        }
        return originalZ;
    }

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="RETURN")})
    private void setupPos(BlockGetter area, Entity focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        if (RenderUtils.vanillaModelAndScript(this.avatar)) {
            FiguraVec3 pos = this.avatar.luaRuntime.renderer.cameraPos;
            if (pos != null && pos.notNaN()) {
                this.move((float)(-pos.z), (float)pos.y, (float)(-pos.x));
            }
            this.avatar = null;
        }
    }

    @Inject(method={"getXRot()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void getXRot(CallbackInfoReturnable<Float> cir) {
        if (UIHelper.paperdoll) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"getYRot()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void getYRot(CallbackInfoReturnable<Float> cir) {
        if (UIHelper.paperdoll) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }
}

