/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.model.ParentType;

public class VanillaModelData {
    public final Map<ParentType, PartData> partMap = new HashMap<ParentType, PartData>(){
        {
            for (ParentType value : ParentType.values()) {
                if (value.provider == null) continue;
                this.put(value, new PartData());
            }
        }
    };

    public void update(LivingEntityRenderer<?, ?> entityRenderer) {
        for (Map.Entry<ParentType, PartData> entry : this.partMap.entrySet()) {
            ParentType parent = entry.getKey();
            EntityModel vanillaModel = entityRenderer.getModel();
            if (vanillaModel == null) continue;
            this.update(parent, vanillaModel);
        }
    }

    public void update(ParentType parent, EntityModel<?> model) {
        ModelPart part = parent.provider.func.apply(model);
        if (part == null) {
            return;
        }
        this.update(parent, part);
    }

    public void update(ParentType parent, ModelPart part) {
        PartData data = this.partMap.get((Object)parent);
        if (data != null) {
            data.updateFromPart(part);
        }
    }

    public static class PartData {
        public final FiguraVec3 pos = FiguraVec3.of();
        public final FiguraVec3 rot = FiguraVec3.of();
        public final FiguraVec3 scale = FiguraVec3.of();
        public boolean visible = false;

        private void updateFromPart(ModelPart model) {
            this.pos.set(model.x, (double)model.y, (double)(-model.z));
            this.rot.set(Math.toDegrees(-model.xRot), Math.toDegrees(-model.yRot), Math.toDegrees(model.zRot));
            this.scale.set(model.xScale, (double)model.yScale, (double)model.zScale);
            this.visible = model.visible;
        }
    }
}

