/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model.rendertasks;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.rendertasks.RenderTask;
import org.figuramc.figura.utils.LuaUtils;

@LuaWhitelist
@LuaTypeDoc(name="BlockTask", value="block_task")
public class BlockTask
extends RenderTask {
    private BlockState block;
    private int cachedComplexity;

    public BlockTask(String name, Avatar owner, FiguraModelPart parent) {
        super(name, owner, parent);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        poseStack.scale(16.0f, 16.0f, 16.0f);
        int newLight = this.customization.light != null ? this.customization.light : light;
        int newOverlay = this.customization.overlay != null ? this.customization.overlay : overlay;
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(this.block, poseStack, buffer, newLight, newOverlay);
    }

    @Override
    public int getComplexity() {
        return this.cachedComplexity;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && this.block != null && !this.block.isAir();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"block"}), @LuaMethodOverload(argumentTypes={BlockStateAPI.class}, argumentNames={"block"})}, aliases={"block"}, value="block_task.set_block")
    public BlockTask setBlock(Object block) {
        this.block = LuaUtils.parseBlockState("block", block);
        Minecraft client = Minecraft.getInstance();
        RandomSource random = client.level != null ? client.level.random : RandomSource.create();
        BakedModel blockModel = client.getBlockRenderer().getBlockModel(this.block);
        this.cachedComplexity = blockModel.getQuads(this.block, null, random).size();
        for (Direction dir : Direction.values()) {
            this.cachedComplexity += blockModel.getQuads(this.block, dir, random).size();
        }
        return this;
    }

    @LuaWhitelist
    public BlockTask block(Object block) {
        return this.setBlock(block);
    }

    @Override
    public String toString() {
        return this.name + " (Block Render Task)";
    }
}

