/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model.rendertasks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.OptionalInt;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.ducks.LivingEntityRendererAccessor;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.mixin.LivingEntityAccessor;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.rendertasks.RenderTask;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="EntityTask", value="entity_task")
public class EntityTask
extends RenderTask {
    @Nullable
    Entity entity;
    long ticksSinceEntity;

    public EntityTask(String name, Avatar owner, FiguraModelPart parent) {
        super(name, owner, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        stack.scale(16.0f, 16.0f, 16.0f);
        if (this.entity != null) {
            assert (Minecraft.getInstance().level != null);
            this.entity.tickCount = (int)(Minecraft.getInstance().level.getGameTime() - this.ticksSinceEntity);
            EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            boolean h = dispatcher.shouldRenderHitBoxes();
            dispatcher.setRenderHitBoxes(false);
            OptionalInt prev = LivingEntityRendererAccessor.overrideOverlay;
            LivingEntityRendererAccessor.overrideOverlay = OptionalInt.of(this.customization.overlay != null ? this.customization.overlay : overlay);
            try {
                Minecraft.getInstance().getEntityRenderDispatcher().render(this.entity, 0.0, 0.0, 0.0, 0.0f, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true), stack, buffer, this.customization.light != null ? this.customization.light : light);
            }
            finally {
                LivingEntityRendererAccessor.overrideOverlay = prev;
                dispatcher.setRenderHitBoxes(h);
            }
        }
    }

    @Override
    public int getComplexity() {
        return 20;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && this.entity != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="entity_task.as_entity")
    public EntityAPI<?> asEntity() {
        return this.entity == null ? null : new EntityAPI<Entity>(this.entity);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"nbt"}), @LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"id", "nbt"})}, value="entity_task.set_nbt")
    @Contract(value="_,_->this")
    public EntityTask setNbt(String nbtOrId, String nullOrNbt) {
        try {
            CompoundTag finalNbt;
            if (nullOrNbt == null) {
                finalNbt = new TagParser(new StringReader(nbtOrId)).readStruct();
                if (!finalNbt.contains("id", 8)) {
                    throw new LuaError("Nbt must contain id");
                }
            } else {
                finalNbt = new TagParser(new StringReader(nullOrNbt)).readStruct();
                finalNbt.put("id", (Tag)StringTag.valueOf((String)nbtOrId));
            }
            assert (Minecraft.getInstance().level != null);
            this.entity = EntityType.loadEntityRecursive((CompoundTag)finalNbt, (Level)Minecraft.getInstance().level, Function.identity());
            if (this.entity == null) {
                throw new LuaError("Could not create entity");
            }
            this.ticksSinceEntity = Minecraft.getInstance().level.getGameTime() - (long)this.entity.tickCount;
        }
        catch (CommandSyntaxException e) {
            throw new LuaError(e.getMessage());
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"distance"})}, value="entity_task.update_walking_distance")
    @Contract(value="_->this")
    public EntityTask updateWalkingDistance(float distance) {
        Entity entity;
        if (this.entity != null && (entity = this.entity) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ((LivingEntityAccessor)living).invokeUpdateWalkAnimation(distance);
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"rotation"})}, value="entity_task.set_head_rotation")
    @Contract(value="_->this")
    public EntityTask setHeadRotation(FiguraVec2 vec2) {
        Entity entity;
        if (this.entity != null && (entity = this.entity) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.yHeadRot = (float)vec2.y;
            living.yHeadRotO = (float)vec2.y;
            living.setXRot((float)vec2.x);
            living.xRotO = (float)vec2.x;
        }
        return this;
    }
}

