/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.utils.ui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.Badges;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.AbstractPanelScreen;
import org.figuramc.figura.gui.screens.FiguraConfirmScreen;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.RenderUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.ui.CustomFramebuffer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL30;

public final class UIHelper {
    public static final ResourceLocation OUTLINE_FILL = new FiguraIdentifier("textures/gui/outline_fill.png");
    public static final ResourceLocation OUTLINE = new FiguraIdentifier("textures/gui/outline.png");
    public static final ResourceLocation TOOLTIP = new FiguraIdentifier("textures/gui/tooltip.png");
    public static final ResourceLocation UI_FONT = new FiguraIdentifier("ui");
    public static final ResourceLocation SPECIAL_FONT = new FiguraIdentifier("special");
    public static final Component UP_ARROW = Component.literal((String)"^").withStyle(Style.EMPTY.withFont(UI_FONT));
    public static final Component DOWN_ARROW = Component.literal((String)"V").withStyle(Style.EMPTY.withFont(UI_FONT));
    private static final CustomFramebuffer FIGURA_FRAMEBUFFER = new CustomFramebuffer();
    private static int previousFBO = -1;
    public static boolean paperdoll = false;
    public static float fireRot = 0.0f;
    public static float dollScale = 1.0f;

    private UIHelper() {
    }

    public static void useFiguraGuiFramebuffer() {
        previousFBO = GL30.glGetInteger((int)36006);
        int width = Minecraft.getInstance().getWindow().getWidth();
        int height = Minecraft.getInstance().getWindow().getHeight();
        FIGURA_FRAMEBUFFER.setSize(width, height);
        GL30.glEnable((int)2960);
        GlStateManager._stencilMask((int)255);
        GlStateManager._glBindFramebuffer((int)36160, (int)FIGURA_FRAMEBUFFER.getFbo());
        GlStateManager._clearStencil((int)0);
        GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._clear((int)17664, (boolean)false);
        Matrix4f mf = RenderSystem.getProjectionMatrix();
        Minecraft.getInstance().getMainRenderTarget().blitToScreen(width, height, false);
        RenderSystem.setProjectionMatrix((Matrix4f)mf, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
    }

    public static void useVanillaFramebuffer() {
        GlStateManager._enableDepthTest();
        GlStateManager._stencilFunc((int)514, (int)0, (int)255);
        GL30.glDisable((int)2960);
        GlStateManager._glBindFramebuffer((int)36009, (int)previousFBO);
        RenderSystem.disableBlend();
        int windowWidth = Minecraft.getInstance().getWindow().getWidth();
        int windowHeight = Minecraft.getInstance().getWindow().getHeight();
        Matrix4f mf = RenderSystem.getProjectionMatrix();
        FIGURA_FRAMEBUFFER.drawToScreen(windowWidth, windowHeight);
        RenderSystem.setProjectionMatrix((Matrix4f)mf, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        RenderSystem.enableBlend();
    }

    public static void drawEntity(float x, float y, float scale, float pitch, float yaw, LivingEntity entity, GuiGraphics gui, Vector3f offset, EntityRenderMode renderMode) {
        float yRot;
        float xRot;
        float headX = entity.getXRot();
        float headY = entity.yHeadRot;
        boolean invisible = entity.isInvisible();
        float bodyY = entity.yBodyRot;
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entity2;
            bodyY = l.yBodyRot;
        }
        double xPos = 0.0;
        double yPos = 0.0;
        switch (renderMode) {
            case PAPERDOLL: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                yPos -= 1.0;
                if (entity.isFallFlying()) {
                    xPos += (double)Mth.triangleWave((float)((float)Math.toRadians(270.0)), (float)((float)Math.PI * 2));
                }
                if (entity.isAutoSpinAttack() || entity.isVisuallySwimming() || entity.isFallFlying()) {
                    yPos += 1.0;
                    entity.setXRot(0.0f);
                }
                Lighting.setupForEntityInInventory();
                if (!((Boolean)Configs.PAPERDOLL_INVISIBLE.value).booleanValue()) break;
                entity.setInvisible(false);
                break;
            }
            case FIGURA_GUI: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                if (!((Boolean)Configs.PREVIEW_HEAD_ROTATION.value).booleanValue()) {
                    entity.setXRot(0.0f);
                    entity.yHeadRot = bodyY;
                }
                yPos -= 1.0;
                Lighting.setupForFlatItems();
                RenderSystem.setShaderLights((Vector3f)((Vector3f)Util.make((Object)new Vector3f(-0.2f, -1.0f, 1.0f), Vector3f::normalize)), (Vector3f)((Vector3f)Util.make((Object)new Vector3f(-0.2f, 0.4f, 0.3f), Vector3f::normalize)));
                entity.setInvisible(false);
                break;
            }
            default: {
                xRot = pitch;
                yRot = yaw + bodyY + 180.0f;
                entity.setXRot(-xRot);
                entity.yHeadRot = -yaw + bodyY;
                Lighting.setupForEntityInInventory();
            }
        }
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((double)x, (double)y, 250.0);
        pose.scale(scale, scale, -scale);
        Avatar avatar = AvatarManager.getAvatar((Entity)entity);
        if (RenderUtils.vanillaModelAndScript(avatar) && !avatar.luaRuntime.renderer.getRootRotationAllowed().booleanValue()) {
            yRot = yaw;
        }
        Quaternionf quaternion = Axis.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion2 = Axis.YP.rotationDegrees(yRot);
        Quaternionf quaternion3 = Axis.XP.rotationDegrees(xRot);
        quaternion3.mul((Quaternionfc)quaternion2);
        quaternion.mul((Quaternionfc)quaternion3);
        pose.mulPose(quaternion);
        quaternion3.conjugate();
        pose.translate(offset.x, offset.y, offset.z);
        Minecraft minecraft = Minecraft.getInstance();
        EntityRenderDispatcher dispatcher = minecraft.getEntityRenderDispatcher();
        boolean renderHitboxes = dispatcher.shouldRenderHitBoxes();
        dispatcher.setRenderHitBoxes(false);
        dispatcher.setRenderShadow(false);
        dispatcher.overrideCameraOrientation(quaternion3);
        MultiBufferSource.BufferSource immediate = minecraft.renderBuffers().bufferSource();
        paperdoll = true;
        fireRot = -yRot;
        dollScale = scale;
        if (avatar != null) {
            avatar.renderMode = renderMode;
        }
        double finalXPos = xPos;
        double finalYPos = yPos;
        RenderSystem.runAsFancy(() -> dispatcher.render((Entity)entity, finalXPos, finalYPos, 0.0, 0.0f, 1.0f, pose, (MultiBufferSource)immediate, 0xF000F0));
        immediate.endBatch();
        paperdoll = false;
        dispatcher.setRenderHitBoxes(renderHitboxes);
        dispatcher.setRenderShadow(true);
        pose.popPose();
        Lighting.setupFor3DItems();
        entity.setXRot(headX);
        entity.yHeadRot = headY;
        entity.setInvisible(invisible);
    }

    public static void enableBlend() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static void prepareTexture(ResourceLocation texture) {
        UIHelper.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
    }

    public static void blit(GuiGraphics gui, int x, int y, int width, int height, ResourceLocation texture) {
        gui.blit(texture, x, y, width, height, 0.0f, 0.0f, 1, 1, 1, 1);
    }

    public static void renderAnimatedBackground(GuiGraphics gui, ResourceLocation texture, float x, float y, float width, float height, float textureWidth, float textureHeight, double speed, float delta) {
        if (speed != 0.0) {
            double d = (double)((float)FiguraMod.ticks + delta) * speed;
            x = (float)((double)x - d % (double)textureWidth);
            y = (float)((double)y - d % (double)textureHeight);
        }
        width += textureWidth;
        height += textureHeight;
        if (speed < 0.0) {
            x -= textureWidth;
            y -= textureHeight;
        }
        UIHelper.renderBackgroundTexture(gui, texture, x, y, width, height, textureWidth, textureHeight);
    }

    public static void renderBackgroundTexture(GuiGraphics gui, ResourceLocation texture, float x, float y, float width, float height, float textureWidth, float textureHeight) {
        UIHelper.prepareTexture(texture);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float u1 = width / textureWidth;
        float v1 = height / textureHeight;
        UIHelper.quad(bufferBuilder, gui.pose().last().pose(), x, y, width, height, -999.0f, 0.0f, u1, 0.0f, v1);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
    }

    public static void fillRounded(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x, y + 1, x + width, y + height - 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
    }

    public static void fillOutline(GuiGraphics gui, int x, int y, int width, int height, int color) {
        gui.fill(x + 1, y, x + width - 1, y + 1, color);
        gui.fill(x, y + 1, x + 1, y + height - 1, color);
        gui.fill(x + width - 1, y + 1, x + width, y + height - 1, color);
        gui.fill(x + 1, y + height - 1, x + width - 1, y + height, color);
    }

    public static void blitSliced(GuiGraphics gui, int x, int y, int width, int height, ResourceLocation texture) {
        UIHelper.blitSliced(gui, x, y, width, height, 0.0f, 0.0f, 15, 15, 15, 15, texture);
    }

    public static void blitSliced(GuiGraphics gui, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, ResourceLocation texture) {
        UIHelper.prepareTexture(texture);
        Matrix4f pose = gui.pose().last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float rWidthThird = (float)regionWidth / 3.0f;
        float rHeightThird = (float)regionHeight / 3.0f;
        UIHelper.quad(buffer, pose, x, y, rWidthThird, rHeightThird, u, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, y, (float)width - rWidthThird * 2.0f, rHeightThird, u + rWidthThird, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, y, rWidthThird, rHeightThird, u + rWidthThird * 2.0f, v, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, x, (float)y + rHeightThird, rWidthThird, (float)height - rHeightThird * 2.0f, u, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, (float)y + rHeightThird, (float)width - rWidthThird * 2.0f, (float)height - rHeightThird * 2.0f, u + rWidthThird, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, (float)y + rHeightThird, rWidthThird, (float)height - rHeightThird * 2.0f, u + rWidthThird * 2.0f, v + rHeightThird, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, x, (float)(y + height) - rHeightThird, rWidthThird, rHeightThird, u, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)x + rWidthThird, (float)(y + height) - rHeightThird, (float)width - rWidthThird * 2.0f, rHeightThird, u + rWidthThird, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        UIHelper.quad(buffer, pose, (float)(x + width) - rWidthThird, (float)(y + height) - rHeightThird, rWidthThird, rHeightThird, u + rWidthThird * 2.0f, v + rHeightThird * 2.0f, rWidthThird, rHeightThird, textureWidth, textureHeight);
        BufferUploader.drawWithShader((MeshData)buffer.build());
    }

    public static void renderHalfTexture(GuiGraphics gui, int x, int y, int width, int height, int textureWidth, ResourceLocation texture) {
        UIHelper.renderHalfTexture(gui, x, y, width, height, 0.0f, 0.0f, textureWidth, 1, textureWidth, 1, texture);
    }

    public static void renderHalfTexture(GuiGraphics gui, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, ResourceLocation texture) {
        UIHelper.enableBlend();
        int w = width / 2;
        gui.blit(texture, x, y, w, height, u, v, w, regionHeight, textureWidth, textureHeight);
        x += w;
        if (width % 2 == 1) {
            ++w;
        }
        gui.blit(texture, x, y, w, height, u + (float)regionWidth - (float)w, v, w, regionHeight, textureWidth, textureHeight);
    }

    public static void renderSprite(GuiGraphics gui, int x, int y, int z, int width, int height, TextureAtlasSprite sprite) {
        UIHelper.prepareTexture(sprite.atlasLocation());
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        UIHelper.quad(bufferBuilder, gui.pose().last().pose(), x, y, width, height, z, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
        BufferUploader.drawWithShader((MeshData)bufferBuilder.build());
    }

    private static void quad(BufferBuilder bufferBuilder, Matrix4f pose, float x, float y, float width, float height, float u, float v, float regionWidth, float regionHeight, int textureWidth, int textureHeight) {
        float u0 = u / (float)textureWidth;
        float v0 = v / (float)textureHeight;
        float u1 = (u + regionWidth) / (float)textureWidth;
        float v1 = (v + regionHeight) / (float)textureHeight;
        UIHelper.quad(bufferBuilder, pose, x, y, width, height, 0.0f, u0, u1, v0, v1);
    }

    private static void quad(BufferBuilder bufferBuilder, Matrix4f pose, float x, float y, float width, float height, float z, float u0, float u1, float v0, float v1) {
        float x1 = x + width;
        float y1 = y + height;
        bufferBuilder.addVertex(pose, x, y1, z).setUv(u0, v1);
        bufferBuilder.addVertex(pose, x1, y1, z).setUv(u1, v1);
        bufferBuilder.addVertex(pose, x1, y, z).setUv(u1, v0);
        bufferBuilder.addVertex(pose, x, y, z).setUv(u0, v0);
    }

    public static void renderWithoutScissors(GuiGraphics gui, Consumer<GuiGraphics> toRun) {
        gui.enableScissor(0, 0, 1, 1);
        RenderSystem.disableScissor();
        toRun.accept(gui);
        gui.disableScissor();
    }

    public static void highlight(GuiGraphics gui, FiguraWidget widget, Component text) {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof AbstractPanelScreen)) {
            return;
        }
        AbstractPanelScreen panel = (AbstractPanelScreen)screen;
        int screenW = panel.width;
        int screenH = panel.height;
        int x = widget.getX();
        int y = widget.getY();
        int width = widget.getWidth();
        int height = widget.getHeight();
        int color = -587202560;
        gui.fill(0, 0, x, y + height, color);
        gui.fill(x + width, y, screenW, screenH, color);
        gui.fill(x, 0, screenW, y, color);
        gui.fill(0, y + height, x + width, screenH, color);
        UIHelper.fillOutline(gui, Math.max(x - 1, 0), Math.max(y - 1, 0), Math.min(width + 2, screenW), Math.min(height + 2, screenH), -1);
        if (text == null) {
            return;
        }
        int bottomDistance = screenH - (y + height);
        int rightDistance = screenW - (x + width);
        int verArea = y * screenW - bottomDistance * screenW;
        int horArea = x * screenH - rightDistance * screenH;
        FiguraVec4 square = new FiguraVec4();
        if (Math.abs(verArea) > Math.abs(horArea)) {
            if (verArea >= 0) {
                square.set(0.0, 0.0, (double)screenW, (double)y);
            } else {
                square.set(0.0, (double)(y + height), (double)screenW, (double)bottomDistance);
            }
        } else if (horArea >= 0) {
            square.set(0.0, 0.0, (double)x, (double)screenH);
        } else {
            square.set(x + width, 0.0, (double)rightDistance, (double)screenH);
        }
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY) {
        return UIHelper.isMouseOver(x, y, width, height, mouseX, mouseY, false);
    }

    public static boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY, boolean force) {
        ContextMenu context = force ? null : UIHelper.getContext();
        return (context == null || !context.isVisible()) && mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    public static void renderOutlineText(GuiGraphics gui, Font textRenderer, Component text, int x, int y, int color, int outline) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        textRenderer.drawInBatch8xOutline(text.getVisualOrderText(), (float)x, (float)y, color, outline, gui.pose().last().pose(), (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.endBatch();
    }

    public static void renderTooltip(GuiGraphics gui, Component tooltip, int mouseX, int mouseY, boolean background) {
        Minecraft minecraft = Minecraft.getInstance();
        int screenX = minecraft.getWindow().getGuiScaledWidth();
        int screenY = minecraft.getWindow().getGuiScaledHeight();
        boolean reduced = (Boolean)Configs.REDUCED_MOTION.value;
        int x = reduced ? 0 : mouseX;
        int y = reduced ? screenY : mouseY - 12;
        Font font = minecraft.font;
        List<FormattedCharSequence> text = TextUtils.wrapTooltip((FormattedText)tooltip, font, x, screenX, 12);
        Objects.requireNonNull(font);
        int height = 9 * text.size();
        y = Math.min(Math.max(y, 0), screenY - height);
        int width = TextUtils.getWidth(text, font);
        if ((x += 12) + width > screenX) {
            x = Math.max(x - width - 24, 0);
        }
        if (reduced) {
            x += (screenX - width) / 2;
            if (background) {
                y -= 4;
            }
        }
        gui.pose().pushPose();
        gui.pose().translate(0.0, 0.0, 999.0);
        if (background) {
            UIHelper.blitSliced(gui, x - 4, y - 4, width + 8, height + 8, TOOLTIP);
        }
        for (int i = 0; i < text.size(); ++i) {
            FormattedCharSequence charSequence = text.get(i);
            Objects.requireNonNull(font);
            gui.drawString(font, charSequence, x, y + 9 * i, 0xFFFFFF);
        }
        gui.pose().popPose();
    }

    public static void renderScrollingText(GuiGraphics gui, Component text, int x, int y, int width, int color) {
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)text);
        int textX = x;
        if (textWidth <= width) {
            gui.drawString(font, text, textX, y, color);
            return;
        }
        Objects.requireNonNull(font);
        gui.enableScissor(x, y, x + width, y + 9);
        gui.drawString(font, text, textX += UIHelper.getTextScrollingOffset(textWidth, width, false), y, color);
        gui.disableScissor();
    }

    public static void renderCenteredScrollingText(GuiGraphics gui, Component text, int x, int y, int width, int height, int color) {
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)text);
        int textX = x + width / 2;
        int n = y + height / 2;
        Objects.requireNonNull(font);
        int textY = n - 9 / 2;
        if (textWidth <= width) {
            gui.drawCenteredString(font, text, textX, textY, color);
            return;
        }
        gui.enableScissor(x, y, x + width, y + height);
        gui.drawCenteredString(font, text, textX += UIHelper.getTextScrollingOffset(textWidth, width, true), textY, color);
        gui.disableScissor();
    }

    private static int getTextScrollingOffset(int textWidth, int width, boolean centered) {
        float speed = ((Float)Configs.TEXT_SCROLL_SPEED.tempValue).floatValue();
        int scrollLen = textWidth - width;
        int startingOffset = (int)Math.ceil((double)scrollLen / 2.0);
        int stopDelay = (int)((float)((Integer)Configs.TEXT_SCROLL_DELAY.tempValue).intValue() * speed);
        int time = scrollLen + stopDelay;
        int totalTime = time * 2;
        int ticks = (int)((float)FiguraMod.ticks * speed);
        int currentTime = ticks % time;
        int dir = ticks % totalTime > time - 1 ? 1 : -1;
        int clamp = Math.min(Math.max(currentTime - stopDelay, 0), scrollLen);
        return (startingOffset - clamp) * dir - (centered ? 0 : startingOffset);
    }

    public static Runnable openURL(String url) {
        Minecraft minecraft = Minecraft.getInstance();
        return () -> minecraft.setScreen((Screen)new FiguraConfirmScreen.FiguraConfirmLinkScreen(bl -> {
            if (bl) {
                Util.getPlatform().openUri(url);
            }
        }, url, minecraft.screen));
    }

    public static void renderLoading(GuiGraphics gui, int x, int y) {
        MutableComponent text = Component.literal((String)Integer.toHexString(Math.abs(FiguraMod.ticks) % 16)).withStyle(Style.EMPTY.withFont(Badges.FONT));
        Font font = Minecraft.getInstance().font;
        int n = x - font.width((FormattedText)text) / 2;
        Objects.requireNonNull(font);
        gui.drawString(font, (Component)text, n, y - 9 / 2, -1, false);
    }

    public static void setContext(ContextMenu context) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)screen;
            panelScreen.contextMenu = context;
        }
    }

    public static ContextMenu getContext() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)screen;
            return panelScreen.contextMenu;
        }
        return null;
    }

    public static void setTooltip(Component text) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AbstractPanelScreen) {
            AbstractPanelScreen panelScreen = (AbstractPanelScreen)screen;
            panelScreen.tooltip = text;
        }
    }

    public static void setTooltip(Style style) {
        if (style == null || style.getHoverEvent() == null) {
            return;
        }
        Component text = (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
        if (text != null) {
            UIHelper.setTooltip(text);
        }
    }
}

