/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.stal111.forbidden_arcanus.common.item.enchantment.ModEnchantmentHelper;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.util.ModTags;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public final class DeathEvents {
    public static final double ENCHANTED_LOST_SOUL_CHANCE = 0.04;

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Level level;
        LivingEntity entity = event.getEntity();
        RandomSource random = entity.getRandom();
        ItemStack stack = event.getSource().getWeaponItem();
        if (stack != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.spawnLostSoul(level2, ModEnchantmentHelper.getLostSoulSpawnChance(level2, stack), entity, random);
        }
    }

    private void spawnLostSoul(ServerLevel level, float spawnChance, LivingEntity entity, RandomSource random) {
        EntityType type = entity.getType();
        if (random.nextDouble() >= (double)spawnChance) {
            return;
        }
        EntityType lostSoulType = null;
        if (type.is(ModTags.EntityTypes.SPAWNS_LOST_SOUL_CHANCE)) {
            lostSoulType = (EntityType)ModEntities.LOST_SOUL.get();
        } else if (type.is(ModTags.EntityTypes.SPAWNS_CORRUPT_LOST_SOUL_CHANCE)) {
            lostSoulType = (EntityType)ModEntities.CORRUPT_LOST_SOUL.get();
        }
        if (lostSoulType != null) {
            if (random.nextDouble() < 0.04) {
                lostSoulType = (EntityType)ModEntities.ENCHANTED_LOST_SOUL.get();
            }
            lostSoulType.spawn(level, entity.blockPosition(), MobSpawnType.TRIGGERED);
        }
    }
}

