/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.neoforge.service;

import dev.obscuria.fragmentum.api.Deferred;
import dev.obscuria.fragmentum.api.v1.client.IClientRegistrar;
import dev.obscuria.fragmentum.neoforge.NeoFragmentum;
import java.util.Arrays;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public record NeoClientRegistrar(String modId) implements IClientRegistrar
{
    @Override
    public <E extends Entity> void registerEntityRenderer(Deferred<EntityType<?>, EntityType<E>> type, EntityRendererProvider<E> provider) {
        NeoFragmentum.eventBus(this.modId).addListener(event -> event.registerEntityRenderer((EntityType)type.value(), provider));
    }

    @Override
    public <T extends BlockEntity> void registerBlockEntityRenderer(Deferred<BlockEntityType<?>, BlockEntityType<T>> type, BlockEntityRendererProvider<T> provider) {
        NeoFragmentum.eventBus(this.modId).addListener(event -> event.registerBlockEntityRenderer((BlockEntityType)type.value(), provider));
    }

    @Override
    public <T extends ParticleOptions> void registerParticleRenderer(Deferred<ParticleType<?>, ParticleType<T>> type, ParticleProvider<T> provider) {
        NeoFragmentum.eventBus(this.modId).addListener(event -> event.registerSpecial((ParticleType)type.value(), provider));
    }

    @Override
    public <T extends ParticleOptions> void registerTexturedParticleRenderer(Deferred<ParticleType<?>, ParticleType<T>> type, IClientRegistrar.TexturedParticleProvider<T> provider) {
        NeoFragmentum.eventBus(this.modId).addListener(event -> event.registerSpriteSet((ParticleType)type.value(), provider::create));
    }

    @Override
    public void registerModelLayer(ModelLayerLocation layerLocation, IClientRegistrar.ModelLayerProvider provider) {
        NeoFragmentum.eventBus(this.modId).addListener(event -> event.registerLayerDefinition(layerLocation, provider::create));
    }

    @Override
    @SafeVarargs
    public final void registerItemColor(IClientRegistrar.ItemColorProvider provider, Deferred<Item, ? extends Item> ... items) {
        NeoFragmentum.eventBus(this.modId).addListener(event -> event.register(provider::getColor, (ItemLike[])Arrays.stream(items).map(Deferred::value).toArray(Item[]::new)));
    }

    @Override
    public void registerItemProperty(ResourceLocation key, ClampedItemPropertyFunction function) {
        ItemProperties.registerGeneric((ResourceLocation)key, (ItemPropertyFunction)function);
    }

    @Override
    public void registerKeyMapping(KeyMapping keyMapping) {
        NeoFragmentum.eventBus(this.modId).addListener(event -> event.register(keyMapping));
    }
}

