/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.FlamesReborn;

import com.gametechbc.gametechbcsspellbooks.effects.FlamesReborn.FlamesRebornHandler;
import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import com.gametechbc.gametechbcsspellbooks.init.GSSounds;
import com.gametechbc.spelllib.particle.ParticleDirection;
import com.gametechbc.spelllib.particle.SphereParticleManager;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class FlamesRebornEffect
extends MagicMobEffect {
    private int tickCounter = 0;

    public FlamesRebornEffect() {
        super(MobEffectCategory.BENEFICIAL, 16729344);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level;
        if (!entity.level().isClientSide && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int duration = entity.getEffect(GSEffects.FLAMES_REBORN).getDuration();
            FlamesRebornHandler.RecordedPosition recordedPosition = FlamesRebornHandler.getRecordedPosition(entity.getUUID());
            if (recordedPosition != null) {
                MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.FIRE, (double)recordedPosition.position.x, (double)(recordedPosition.position.y + 0.2), (double)recordedPosition.position.z, (int)10, (double)0.2, (double)1.5, (double)0.2, (double)0.095, (boolean)false);
            }
            if (recordedPosition != null) {
                ++this.tickCounter;
                int tickInterval = duration > 200 ? 20 : (duration > 140 ? 15 : (duration > 100 ? 12 : (duration > 60 ? 10 : 5)));
                if (this.tickCounter >= tickInterval) {
                    this.tickCounter = 0;
                    MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)new BlastwaveParticleOptions(new Vector3f(1.0f, 0.8f, 0.2f), 3.0f), (double)recordedPosition.position.x, (double)(recordedPosition.position.y + (double)0.165f), (double)recordedPosition.position.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                }
                int particleCount = 1;
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
                    double offsetY = entity.getRandom().nextDouble() * (double)entity.getBbHeight();
                    double offsetZ = (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
                    double velocityX = (entity.getRandom().nextDouble() - 0.5) * 0.2;
                    double velocityY = (entity.getRandom().nextDouble() - 0.5) * 0.2;
                    double velocityZ = (entity.getRandom().nextDouble() - 0.5) * 0.2;
                    MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)ParticleHelper.FIRE, (double)(entity.getX() + offsetX), (double)(entity.getY() + offsetY), (double)(entity.getZ() + offsetZ), (int)1, (double)velocityX, (double)velocityY, (double)velocityZ, (double)0.0, (boolean)false);
                }
            }
        }
        return true;
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        super.onEffectAdded(entity, amplifier);
        FlamesRebornHandler.recordPosition(entity);
    }

    public void onEffectRemoved(LivingEntity entity, int amplifier) {
        super.onEffectRemoved(entity, amplifier);
        SphereParticleManager.spawnParticles((Level)entity.level(), (LivingEntity)entity, (int)35, (ParticleOptions)ParticleHelper.FIRE, (ParticleDirection)ParticleDirection.INWARD, (double)3.0);
        FlamesRebornHandler.teleportEntityToRecordedPosition(entity);
        FlamesRebornHandler.RecordedPosition recordedPosition = FlamesRebornHandler.getRecordedPosition(entity.getUUID());
        if (recordedPosition != null) {
            SphereParticleManager.spawnParticles((Level)entity.level(), (LivingEntity)entity, (int)50, (ParticleOptions)ParticleHelper.FIRE, (ParticleDirection)ParticleDirection.OUTWARD, (double)3.0);
            entity.level().playSound(null, (Entity)entity, (SoundEvent)GSSounds.FLAMES_REBORN_REVIVE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!entity.level().isClientSide) {
                CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, entity.position(), 15.0f));
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String[] messages = new String[]{"quote.gametechbcs_spellbooks.flames_reborn_revive_1", "quote.gametechbcs_spellbooks.flames_reborn_revive_2", "quote.gametechbcs_spellbooks.flames_reborn_revive_3", "quote.gametechbcs_spellbooks.flames_reborn_revive_4", "quote.gametechbcs_spellbooks.flames_reborn_revive_5", "quote.gametechbcs_spellbooks.flames_reborn_revive_6"};
            String selectedMessage = messages[player.getRandom().nextInt(messages.length)];
            player.displayClientMessage((Component)Component.translatable((String)selectedMessage).withStyle(style -> style.withColor(16766783)), true);
        }
        FlamesRebornHandler.clearRecordedPosition(entity);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

